/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.sync.source;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.pipecraft.infra.io.FileReadOptions;
import org.pipecraft.infra.io.FileUtils;
import org.pipecraft.infra.io.SizedInputStream;
import org.pipecraft.infra.storage.Bucket;
import org.pipecraft.infra.storage.Storage;
import org.pipecraft.pipes.exceptions.IOPipeException;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.sync.source.InputStreamPipe;

public class StorageTxtFileReaderPipe
extends InputStreamPipe<String> {
    private static final int DEFAULT_CHUNK_SIZE = 0;
    private static final FileReadOptions DEFAULT_FILE_READ_OPTIONS = new FileReadOptions();
    private final Charset charset;
    private final Storage<?, ?> storageConnector;
    private final String bucketName;
    private final String path;
    private final int chunkSize;
    private final FileReadOptions readOptions;
    private BufferedReader reader;
    private String next;

    public StorageTxtFileReaderPipe(Storage<?, ?> storageConnector, String bucketName, String path, Charset charset, int chunkSize, FileReadOptions options) {
        super(0, options.getCompression());
        this.storageConnector = storageConnector;
        this.bucketName = bucketName;
        this.path = path;
        this.charset = charset;
        this.chunkSize = chunkSize;
        this.readOptions = options;
    }

    public StorageTxtFileReaderPipe(Storage<?, ?> storageConnector, String bucket, String path, Charset charset) {
        this(storageConnector, bucket, path, charset, 0, DEFAULT_FILE_READ_OPTIONS);
    }

    public StorageTxtFileReaderPipe(Storage<?, ?> storageConnector, String bucket, String path) {
        this(storageConnector, bucket, path, StandardCharsets.UTF_8, 0, DEFAULT_FILE_READ_OPTIONS);
    }

    public StorageTxtFileReaderPipe(Storage<?, ?> storageConnector, String bucket, String path, FileReadOptions options) {
        this(storageConnector, bucket, path, StandardCharsets.UTF_8, 0, options);
    }

    @Override
    public String next() throws PipeException, InterruptedException {
        String toReturn = this.next;
        this.prepareNext();
        return toReturn;
    }

    @Override
    public String peek() {
        return this.next;
    }

    @Override
    protected SizedInputStream createInputStream() throws IOException, InterruptedException {
        Object bucket = this.storageConnector.getBucket(this.bucketName);
        return ((Bucket)bucket).getAsStream(this.path, this.chunkSize);
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        super.start();
        this.reader = new BufferedReader(new InputStreamReader(this.getInputStream(), this.charset), this.readOptions.getBufferSize());
        this.prepareNext();
    }

    @Override
    public void close() throws IOException {
        FileUtils.close((Closeable)this.reader);
    }

    private void prepareNext() throws IOPipeException {
        try {
            this.next = this.reader.readLine();
        }
        catch (IOException e) {
            throw new IOPipeException(e);
        }
    }
}

