/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.terminal;

import java.io.File;
import org.pipecraft.infra.io.FileWriteOptions;
import org.pipecraft.infra.math.ArithmeticUtils;
import org.pipecraft.pipes.async.AsyncPipe;
import org.pipecraft.pipes.serialization.EncoderFactory;
import org.pipecraft.pipes.terminal.AsyncSharderPipe;

public class AsyncSharderByHashPipe<T>
extends AsyncSharderPipe<T> {
    public AsyncSharderByHashPipe(AsyncPipe<T> input, EncoderFactory<? super T> encoderFactory, int shardCount, File folder, FileWriteOptions writeOptions) {
        super(input, encoderFactory, v -> AsyncSharderByHashPipe.getShardFor(v, shardCount), folder, writeOptions);
    }

    public AsyncSharderByHashPipe(AsyncPipe<T> input, EncoderFactory<? super T> encoderFactory, int shardCount, File folder) {
        super(input, encoderFactory, v -> AsyncSharderByHashPipe.getShardFor(v, shardCount), folder);
    }

    private static <V> String getShardFor(V item, int shardCount) {
        return String.valueOf(ArithmeticUtils.getShardByHash(item, shardCount));
    }
}

