/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.terminal;

import java.io.File;
import org.pipecraft.infra.io.FileWriteOptions;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.serialization.EncoderFactory;
import org.pipecraft.pipes.sync.Pipe;
import org.pipecraft.pipes.sync.inter.IntermediateBinFileWriterPipe;
import org.pipecraft.pipes.terminal.CompoundTerminalPipe;
import org.pipecraft.pipes.terminal.ConsumerPipe;
import org.pipecraft.pipes.terminal.TerminalPipe;

public class BinFileWriterPipe<T>
extends CompoundTerminalPipe {
    private final FileWriteOptions writeOptions;
    private final Pipe<T> input;
    private final EncoderFactory<? super T> encoderFactory;
    private final File outputFile;

    public BinFileWriterPipe(Pipe<T> input, File outputFile, FileWriteOptions options, EncoderFactory<? super T> encoderFactory) {
        if (options.isTemp()) {
            outputFile.deleteOnExit();
        }
        this.writeOptions = options;
        this.input = input;
        this.encoderFactory = encoderFactory;
        this.outputFile = outputFile;
    }

    public BinFileWriterPipe(Pipe<T> input, File outputFile, EncoderFactory<? super T> encoderFactory) {
        this(input, outputFile, new FileWriteOptions(), encoderFactory);
    }

    @Override
    protected TerminalPipe createPipeline() throws PipeException, InterruptedException {
        IntermediateBinFileWriterPipe<? super T> inter = new IntermediateBinFileWriterPipe<T>(this.input, this.outputFile, this.writeOptions, this.encoderFactory);
        return new ConsumerPipe<T>(inter);
    }
}

