/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.terminal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.sync.Pipe;
import org.pipecraft.pipes.terminal.TerminalPipe;

public class CollectionWriterPipe<T>
extends TerminalPipe {
    private final Pipe<T> input;
    private final Collection<T> outputCollection;

    public CollectionWriterPipe(Pipe<T> input, Collection<T> outputCollection) {
        this.input = input;
        this.outputCollection = outputCollection;
    }

    public CollectionWriterPipe(Pipe<T> input) {
        this(input, new ArrayList());
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        T next;
        this.input.start();
        while ((next = this.input.next()) != null) {
            this.outputCollection.add(next);
        }
    }

    public Collection<T> getItems() {
        return this.outputCollection;
    }
}

