/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.terminal;

import java.io.IOException;
import org.pipecraft.infra.concurrent.FailableConsumer;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.sync.Pipe;
import org.pipecraft.pipes.terminal.TerminalPipe;

public class ConsumerPipe<T>
extends TerminalPipe {
    private final Pipe<T> input;
    private final FailableConsumer<? super T, PipeException> action;
    private final Runnable terminationAction;

    public ConsumerPipe(Pipe<T> input, FailableConsumer<? super T, PipeException> itemAction, Runnable terminationAction) {
        this.input = input;
        this.action = itemAction;
        this.terminationAction = terminationAction;
    }

    public ConsumerPipe(Pipe<T> input, FailableConsumer<? super T, PipeException> itemAction) {
        this(input, itemAction, () -> {});
    }

    public ConsumerPipe(Pipe<T> input, Runnable terminationAction) {
        this(input, v -> {}, terminationAction);
    }

    public ConsumerPipe(Pipe<T> input) {
        this(input, v -> {}, () -> {});
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        T item;
        this.input.start();
        while ((item = this.input.next()) != null) {
            this.action.accept(item);
        }
        this.terminationAction.run();
    }
}

