/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.terminal;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.pipecraft.infra.concurrent.ParallelTaskProcessor;
import org.pipecraft.pipes.BasePipe;
import org.pipecraft.pipes.async.AsyncPipe;
import org.pipecraft.pipes.async.AsyncPipeListener;
import org.pipecraft.pipes.exceptions.IOPipeException;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.sync.Pipe;
import org.pipecraft.pipes.terminal.TerminalPipe;
import org.pipecraft.pipes.utils.PipeUtils;

public class ParallelConsumerPipe
extends TerminalPipe {
    private final Collection<? extends BasePipe> inputs;
    private final int parallelism;
    private final Runnable terminationAction;

    public ParallelConsumerPipe(int parallelism, Collection<? extends BasePipe> inputs, Runnable terminationAction) {
        this.parallelism = parallelism;
        this.inputs = inputs;
        this.terminationAction = terminationAction;
    }

    public ParallelConsumerPipe(int parallelism, Collection<? extends BasePipe> inputs) {
        this(parallelism, inputs, () -> {});
    }

    public ParallelConsumerPipe(int parallelism, BasePipe ... inputs) {
        this(parallelism, Arrays.asList(inputs));
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        ParallelTaskProcessor.runFailable(this.inputs, this.parallelism, p -> {
            block17: {
                Exception pe = null;
                try {
                    if (p instanceof Pipe) {
                        ParallelConsumerPipe.consumeSyncPipe((Pipe)p);
                        break block17;
                    }
                    if (p instanceof AsyncPipe) {
                        ParallelConsumerPipe.consumeAsyncPipe((AsyncPipe)p);
                        break block17;
                    }
                    if (p instanceof TerminalPipe) {
                        ParallelConsumerPipe.consumeTerminalPipe((TerminalPipe)p);
                        break block17;
                    }
                    throw new IllegalArgumentException("Unsupported pipe type: " + p.getClass().getSimpleName());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (RuntimeException | PipeException e) {
                    pe = e;
                    throw e;
                }
                finally {
                    try {
                        p.close();
                    }
                    catch (IOException e) {
                        IOPipeException toThrow = new IOPipeException(e);
                        if (pe != null) {
                            toThrow.addSuppressed(pe);
                        }
                        throw toThrow;
                    }
                }
            }
        });
        this.terminationAction.run();
    }

    @Override
    public float getProgress() {
        return PipeUtils.getAverageProgress(this.inputs);
    }

    private static void consumeAsyncPipe(AsyncPipe<?> asyncPipe) throws InterruptedException, PipeException {
        final CountDownLatch terminationLatch = new CountDownLatch(1);
        final AtomicReference exception = new AtomicReference();
        asyncPipe.setListener(new AsyncPipeListener<Object>(){

            @Override
            public void next(Object item) throws PipeException, InterruptedException {
            }

            @Override
            public void done() throws InterruptedException {
                terminationLatch.countDown();
            }

            @Override
            public void error(PipeException e) throws InterruptedException {
                exception.set(e);
                terminationLatch.countDown();
            }
        });
        terminationLatch.await();
        if (exception.get() != null) {
            throw (PipeException)exception.get();
        }
    }

    private static void consumeSyncPipe(Pipe<?> p) throws PipeException, InterruptedException {
        p.start();
        while (p.next() != null) {
        }
    }

    private static void consumeTerminalPipe(TerminalPipe p) throws PipeException, InterruptedException {
        p.start();
    }
}

