/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.terminal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.mutable.MutableInt;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.sync.Pipe;
import org.pipecraft.pipes.terminal.TerminalPipe;

public class PercentilePipe<T, C extends Comparable<C>>
extends TerminalPipe {
    private final Pipe<T> input;
    private final double p;
    private final Function<T, C> extractor;
    private volatile C percentileValue;

    public PercentilePipe(Pipe<T> input, double p, Function<T, C> sortingComponentExtractor) {
        this.input = input;
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("Illegal required percentile: " + p);
        }
        this.p = p;
        this.extractor = sortingComponentExtractor;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        T next;
        this.input.start();
        HashMap<Comparable, MutableInt> bucketCounts = new HashMap<Comparable, MutableInt>();
        int totalItemsCount = 0;
        while ((next = this.input.next()) != null) {
            ++totalItemsCount;
            Comparable c = (Comparable)this.extractor.apply(next);
            bucketCounts.computeIfAbsent(c, k -> new MutableInt()).increment();
        }
        if (bucketCounts.isEmpty()) {
            return;
        }
        ArrayList pairs = new ArrayList(bucketCounts.entrySet());
        pairs.sort(Map.Entry.comparingByKey());
        int lookupValue = (int)Math.round(this.p * (double)totalItemsCount);
        int cumulativeItemsCount = 0;
        for (Map.Entry entry : pairs) {
            if ((cumulativeItemsCount += ((MutableInt)entry.getValue()).getValue().intValue()) < lookupValue) continue;
            this.percentileValue = (Comparable)entry.getKey();
            break;
        }
    }

    public C getPercentileValue() {
        return this.percentileValue;
    }
}

