/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.terminal;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.sync.Pipe;
import org.pipecraft.pipes.terminal.TerminalPipe;

public class QueueWriterPipe<T>
extends TerminalPipe {
    private final BlockingQueue<T> queue;
    private final T successMarker;
    private final T errorMarker;
    private final Pipe<T> inputPipe;

    public QueueWriterPipe(Pipe<T> inputPipe, BlockingQueue<T> queue, T successMarker, T errorMarker) {
        this.inputPipe = inputPipe;
        this.queue = queue;
        this.successMarker = successMarker;
        this.errorMarker = errorMarker;
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        try {
            T item;
            this.inputPipe.start();
            while ((item = this.inputPipe.next()) != null) {
                this.queue.put(item);
            }
            this.queue.put(this.successMarker);
        }
        catch (Throwable e) {
            while (!this.queue.offer(this.errorMarker)) {
                this.queue.clear();
            }
            throw e;
        }
    }

    @Override
    public float getProgress() {
        return this.inputPipe.getProgress();
    }

    @Override
    public void close() throws IOException {
        this.inputPipe.close();
    }
}

