/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.terminal;

import java.io.File;
import java.util.function.Function;
import org.pipecraft.infra.concurrent.FailableFunction;
import org.pipecraft.infra.io.FileWriteOptions;
import org.pipecraft.infra.math.ArithmeticUtils;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.serialization.EncoderFactory;
import org.pipecraft.pipes.sync.Pipe;
import org.pipecraft.pipes.terminal.SharderByItemPipe;

public class SharderByHashPipe<T>
extends SharderByItemPipe<T> {
    public SharderByHashPipe(Pipe<T> input, EncoderFactory<T> encoderFactory, FailableFunction<? super T, ?, PipeException> featureSelectorFunction, Function<Integer, String> fileNameFunction, int shardCount, File folder, FileWriteOptions writeOptions) {
        super(input, encoderFactory, SharderByHashPipe.transformFunction(featureSelectorFunction, fileNameFunction, shardCount), folder, writeOptions);
    }

    public SharderByHashPipe(Pipe<T> input, EncoderFactory<T> encoderFactory, FailableFunction<? super T, ?, PipeException> featureSelectorFunction, int shardCount, File folder, FileWriteOptions writeOptions) {
        this(input, encoderFactory, featureSelectorFunction, String::valueOf, shardCount, folder, writeOptions);
    }

    private static <T> FailableFunction<? super T, String, PipeException> transformFunction(FailableFunction<T, ?, PipeException> selectorFunction, Function<Integer, String> fileNameFunction, int shardCount) {
        return v -> (String)fileNameFunction.apply(ArithmeticUtils.getShardByHash(selectorFunction.apply(v), shardCount));
    }
}

