/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.terminal;

import java.io.File;
import java.util.Map;
import org.pipecraft.infra.concurrent.FailableFunction;
import org.pipecraft.infra.io.FileWriteOptions;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.serialization.EncoderFactory;
import org.pipecraft.pipes.sync.Pipe;
import org.pipecraft.pipes.sync.inter.IntermediateSharderBySeqPipe;
import org.pipecraft.pipes.terminal.CompoundTerminalPipe;
import org.pipecraft.pipes.terminal.ConsumerPipe;
import org.pipecraft.pipes.terminal.TerminalPipe;

public class SharderBySeqPipe<T>
extends CompoundTerminalPipe {
    private final Pipe<T> input;
    private final EncoderFactory<? super T> encoderFactory;
    private final FailableFunction<? super T, String, PipeException> selector;
    private final File folder;
    private final FileWriteOptions fileWriteOptions;
    private volatile Map<String, Integer> shardStats;

    public SharderBySeqPipe(Pipe<T> input, EncoderFactory<? super T> encoderFactory, FailableFunction<? super T, String, PipeException> shardSelectorFunction, File folder, FileWriteOptions fileWriteOptions) {
        this.input = input;
        this.encoderFactory = encoderFactory;
        this.selector = shardSelectorFunction;
        this.folder = folder;
        this.fileWriteOptions = fileWriteOptions;
    }

    public SharderBySeqPipe(Pipe<T> input, EncoderFactory<? super T> encoderFactory, FailableFunction<? super T, String, PipeException> shardSelectorFunction, File folder) {
        this(input, encoderFactory, shardSelectorFunction, folder, new FileWriteOptions());
    }

    @Override
    protected TerminalPipe createPipeline() throws PipeException, InterruptedException {
        IntermediateSharderBySeqPipe<? super T> writerP = new IntermediateSharderBySeqPipe<T>(this.input, this.encoderFactory, this.selector, this.folder, this.fileWriteOptions);
        return new ConsumerPipe<T>(writerP, () -> {
            this.shardStats = writerP.getShardSizes();
        });
    }

    public Map<String, Integer> getShardSizes() {
        return this.shardStats;
    }
}

