/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.utils.multi;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.pipecraft.infra.io.FileReadOptions;
import org.pipecraft.pipes.serialization.DecoderFactory;
import org.pipecraft.pipes.sync.source.BinInputReaderPipe;
import org.pipecraft.pipes.utils.PipeReaderSupplier;
import org.pipecraft.pipes.utils.ShardSpecifier;

public class LocalMultiFileReaderConfig<T> {
    private final Predicate<File> fileFilter;
    private final ShardSpecifier shardSpecifier;
    private final boolean balancedSharding;
    private final Collection<String> paths;
    private final boolean recursivePaths;
    private final PipeReaderSupplier<T, File> pipeSupplier;
    private final int threadNum;
    private final Comparator<File> fileOrder;

    private LocalMultiFileReaderConfig(Builder<T> builder) {
        this.fileFilter = builder.fileFilter;
        this.shardSpecifier = builder.shardSpecifier;
        this.balancedSharding = builder.isBalanced;
        this.paths = builder.paths;
        this.recursivePaths = builder.recursivePaths;
        this.pipeSupplier = builder.pipeSupplier;
        this.threadNum = builder.threadNum;
        this.fileOrder = builder.fileOrder;
    }

    public static <T> Builder<T> builder(PipeReaderSupplier<T, File> supplier) {
        return new Builder<T>(supplier);
    }

    public static <T> Builder<T> builder(DecoderFactory<T> decoderFactory, FileReadOptions readOptions) {
        return new Builder<T>(decoderFactory, readOptions);
    }

    public static <T> Builder<T> builder(DecoderFactory<T> decoderFactory) {
        return LocalMultiFileReaderConfig.builder(decoderFactory, new FileReadOptions());
    }

    public Predicate<File> getFileFilter() {
        return this.fileFilter;
    }

    public ShardSpecifier getShardSpecifier() {
        return this.shardSpecifier;
    }

    public boolean isBalancedSharding() {
        return this.balancedSharding;
    }

    public Collection<String> getPaths() {
        return this.paths;
    }

    public boolean isRecursivePaths() {
        return this.recursivePaths;
    }

    public PipeReaderSupplier<T, File> getPipeSupplier() {
        return this.pipeSupplier;
    }

    public int getThreadNum() {
        return this.threadNum;
    }

    public Comparator<File> getFileOrder() {
        return this.fileOrder;
    }

    public static class Builder<T> {
        private Predicate<File> fileFilter = f -> true;
        private ShardSpecifier shardSpecifier;
        private boolean isBalanced = false;
        private Collection<String> paths;
        private boolean recursivePaths = false;
        private final PipeReaderSupplier<T, File> pipeSupplier;
        private int threadNum = Runtime.getRuntime().availableProcessors();
        private Comparator<File> fileOrder = Comparator.comparing(File::getAbsolutePath);

        private Builder(PipeReaderSupplier<T, File> supplier) {
            this.pipeSupplier = supplier;
        }

        private Builder(DecoderFactory<T> decoderFactory, FileReadOptions readOptions) {
            this.pipeSupplier = (is, b) -> new BinInputReaderPipe(is, decoderFactory, readOptions);
        }

        public Builder<T> andFilter(Predicate<File> fileFilter) {
            this.fileFilter = this.fileFilter.and(fileFilter);
            return this;
        }

        public Builder<T> andFilter(String fileRegex) {
            Pattern pattern = Pattern.compile(fileRegex);
            return this.andFilter((File f) -> pattern.matcher(f.getAbsolutePath()).matches());
        }

        public Builder<T> shard(ShardSpecifier shardSpecifier, boolean isBalanced) {
            this.shardSpecifier = shardSpecifier;
            this.isBalanced = isBalanced;
            return this;
        }

        public Builder<T> shard(ShardSpecifier shardSpecifier) {
            return this.shard(shardSpecifier, false);
        }

        public Builder<T> paths(Collection<String> paths, boolean isRecursive) {
            this.paths = paths;
            this.recursivePaths = isRecursive;
            return this;
        }

        public Builder<T> paths(Collection<String> paths) {
            return this.paths(paths, false);
        }

        public Builder<T> paths(String ... paths) {
            return this.paths(Arrays.asList(paths), false);
        }

        public Builder<T> paths(File ... folders) {
            List<String> paths = Arrays.stream(folders).map(File::getAbsolutePath).collect(Collectors.toList());
            return this.paths(paths, false);
        }

        public Builder<T> paths(String path, boolean isRecursive) {
            return this.paths(Collections.singletonList(path), isRecursive);
        }

        public Builder<T> paths(String path) {
            return this.paths(path, false);
        }

        public Builder<T> threadNum(int threadNum) {
            this.threadNum = threadNum;
            return this;
        }

        public Builder<T> fileOrder(Comparator<File> fileOrder) {
            this.fileOrder = fileOrder;
            return this;
        }

        public LocalMultiFileReaderConfig<T> build() {
            if (this.paths == null || this.paths.isEmpty()) {
                throw new IllegalArgumentException("Paths must be specified");
            }
            if (this.pipeSupplier == null) {
                throw new IllegalArgumentException("File handler must be specified");
            }
            return new LocalMultiFileReaderConfig(this);
        }
    }
}

