/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.utils.multi;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.pipecraft.infra.io.FileReadOptions;
import org.pipecraft.infra.io.FileUtils;
import org.pipecraft.infra.storage.Bucket;
import org.pipecraft.infra.storage.Storage;
import org.pipecraft.pipes.serialization.DecoderFactory;
import org.pipecraft.pipes.sync.source.BinInputReaderPipe;
import org.pipecraft.pipes.utils.PipeReaderSupplier;
import org.pipecraft.pipes.utils.ShardSpecifier;

public class StorageMultiFileReaderConfig<T, B> {
    private final Predicate<B> fileFilter;
    private final ShardSpecifier shardSpecifier;
    private final boolean balancedSharding;
    private final Bucket<B> bucket;
    private final Collection<String> paths;
    private final boolean recursivePaths;
    private final PipeReaderSupplier<T, B> pipeSupplier;
    private final int threadNum;
    private final boolean downloadFirst;
    private final File tmpFolder;
    private final Comparator<B> fileOrder;

    private StorageMultiFileReaderConfig(Builder<T, B> builder) {
        this.fileFilter = builder.fileFilter;
        this.shardSpecifier = builder.shardSpecifier;
        this.balancedSharding = builder.isBalanced;
        this.bucket = builder.bucket;
        this.paths = builder.paths;
        this.recursivePaths = builder.recursivePaths;
        this.pipeSupplier = builder.pipeSupplier;
        this.threadNum = builder.threadNum;
        this.downloadFirst = builder.downloadFirst;
        this.tmpFolder = builder.tmpFolder;
        this.fileOrder = builder.fileOrder;
    }

    public static <T, B> Builder<T, B> builder(PipeReaderSupplier<T, B> supplier) {
        return new Builder<T, B>(supplier);
    }

    public static <T, B> Builder<T, B> builder(DecoderFactory<T> decoderFactory, FileReadOptions readOptions) {
        return new Builder(decoderFactory, readOptions);
    }

    public static <T, B> Builder<T, B> builder(DecoderFactory<T> decoderFactory) {
        return StorageMultiFileReaderConfig.builder(decoderFactory, new FileReadOptions());
    }

    public Predicate<B> getFileFilter() {
        return this.fileFilter;
    }

    public ShardSpecifier getShardSpecifier() {
        return this.shardSpecifier;
    }

    public boolean isBalancedSharding() {
        return this.balancedSharding;
    }

    public Bucket<B> getBucket() {
        return this.bucket;
    }

    public Collection<String> getPaths() {
        return this.paths;
    }

    public boolean isRecursivePaths() {
        return this.recursivePaths;
    }

    public PipeReaderSupplier<T, B> getPipeSupplier() {
        return this.pipeSupplier;
    }

    public int getThreadNum() {
        return this.threadNum;
    }

    public boolean isDownloadFirst() {
        return this.downloadFirst;
    }

    public File getTmpFolder() {
        return this.tmpFolder;
    }

    public Comparator<B> getFileOrder() {
        return this.fileOrder;
    }

    public static class Builder<T, B> {
        private Predicate<B> fileFilter = f -> true;
        private final Collection<Pattern> regexFilters = new ArrayList<Pattern>();
        private final Collection<Predicate<String>> pathFilters = new ArrayList<Predicate<String>>();
        private ShardSpecifier shardSpecifier;
        private boolean isBalanced = false;
        private Bucket<B> bucket;
        private Collection<String> paths;
        private boolean recursivePaths = false;
        private final PipeReaderSupplier<T, B> pipeSupplier;
        private int threadNum = Runtime.getRuntime().availableProcessors();
        private boolean downloadFirst = false;
        private File tmpFolder;
        private Comparator<B> fileOrder;

        private Builder(PipeReaderSupplier<T, B> supplier) {
            this.pipeSupplier = supplier;
        }

        private Builder(DecoderFactory<T> decoderFactory, FileReadOptions readOptions) {
            this.pipeSupplier = (is, b) -> new BinInputReaderPipe(is, decoderFactory, readOptions);
        }

        public Builder<T, B> andFilter(Predicate<B> fileFilter) {
            this.fileFilter = this.fileFilter.and(fileFilter);
            return this;
        }

        public Builder<T, B> andPathFilter(Predicate<String> filePathFilter) {
            this.pathFilters.add(filePathFilter);
            return this;
        }

        public Builder<T, B> andFilter(String fileRegex) {
            Pattern pattern = Pattern.compile(fileRegex);
            this.regexFilters.add(pattern);
            return this;
        }

        public Builder<T, B> shard(ShardSpecifier shardSpecifier, boolean isBalanced) {
            this.shardSpecifier = shardSpecifier;
            this.isBalanced = isBalanced;
            return this;
        }

        public Builder<T, B> shard(ShardSpecifier shardSpecifier) {
            return this.shard(shardSpecifier, false);
        }

        public Builder<T, B> bucket(Storage<?, B> storage, String bucketName) {
            this.bucket = storage.getBucket(bucketName);
            return this;
        }

        public Builder<T, B> bucket(Bucket<B> bucket) {
            this.bucket = bucket;
            return this;
        }

        public Builder<T, B> paths(Collection<String> paths, boolean isRecursive) {
            this.paths = paths;
            this.recursivePaths = isRecursive;
            return this;
        }

        public Builder<T, B> paths(Collection<String> paths) {
            return this.paths(paths, false);
        }

        public Builder<T, B> paths(String ... paths) {
            return this.paths(Arrays.asList(paths), false);
        }

        public Builder<T, B> paths(String path, boolean isRecursive) {
            return this.paths(Collections.singletonList(path), isRecursive);
        }

        public Builder<T, B> paths(String path) {
            return this.paths(path, false);
        }

        public Builder<T, B> threadNum(int threadNum) {
            this.threadNum = threadNum;
            return this;
        }

        public Builder<T, B> downloadFirst(File tmpFolder) {
            this.downloadFirst = true;
            this.tmpFolder = tmpFolder;
            return this;
        }

        public Builder<T, B> downloadFirst() {
            return this.downloadFirst(FileUtils.getSystemDefaultTmpFolder());
        }

        public Builder<T, B> fileOrder(Comparator<B> fileOrder) {
            this.fileOrder = fileOrder;
            return this;
        }

        public StorageMultiFileReaderConfig<T, B> build() {
            if (this.bucket == null) {
                throw new IllegalArgumentException("Bucket must be specified");
            }
            if (this.paths == null || this.paths.isEmpty()) {
                throw new IllegalArgumentException("Paths must be specified");
            }
            if (this.pipeSupplier == null) {
                throw new IllegalArgumentException("File handler must be specified");
            }
            if (this.fileOrder == null) {
                this.fileOrder = Comparator.comparing(m -> this.bucket.getPath(m));
            }
            for (Pattern pattern : this.regexFilters) {
                this.fileFilter = this.fileFilter.and(f -> p.matcher(this.bucket.getPath(f)).matches());
            }
            for (Predicate predicate : this.pathFilters) {
                this.fileFilter = this.fileFilter.and(f -> pathFilter.test(this.bucket.getPath(f)));
            }
            return new StorageMultiFileReaderConfig(this);
        }
    }
}

