/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.pipecraft.infra.concurrent.AbstractCheckedFuture;
import org.pipecraft.infra.concurrent.CheckedFuture;

public class CheckedFutureTransformer<S, T, E extends Exception>
implements CheckedFuture<T, E> {
    private final AbstractCheckedFuture<S, E> future;
    private final Function<S, T> mappingFunction;

    public CheckedFutureTransformer(AbstractCheckedFuture<S, E> future, Function<S, T> mappingFunction) {
        this.future = future;
        this.mappingFunction = mappingFunction;
    }

    @Override
    public T checkedGet() throws InterruptedException, E {
        return this.mappingFunction.apply(this.future.checkedGet());
    }

    @Override
    public T checkedGet(long timeout, TimeUnit unit) throws TimeoutException, InterruptedException, E {
        return this.mappingFunction.apply(this.future.checkedGet(timeout, unit));
    }

    public void addListener(Runnable listener, Executor executor) {
        this.future.addListener(listener, executor);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    public boolean isDone() {
        return this.future.isDone();
    }

    public T get() throws InterruptedException, ExecutionException {
        return this.mappingFunction.apply(this.future.get());
    }

    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.mappingFunction.apply(this.future.get(timeout, unit));
    }
}

