/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.concurrent;

import java.util.Objects;
import java.util.function.Consumer;

@FunctionalInterface
public interface FailableConsumer<T, E extends Exception> {
    public void accept(T var1) throws E;

    default public FailableConsumer<T, E> andThen(FailableConsumer<? super T, ? extends E> after) {
        Objects.requireNonNull(after);
        return t -> {
            this.accept(t);
            after.accept(t);
        };
    }

    public static <T, E extends Exception> FailableConsumer<T, E> fromConsumer(final Consumer<T> consumer) {
        return new FailableConsumer<T, E>(){

            @Override
            public void accept(T t) throws Exception {
                consumer.accept(t);
            }
        };
    }
}

