/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.concurrent;

import java.util.Objects;
import java.util.function.Consumer;

@FunctionalInterface
public interface FailableInterruptibleConsumer<T, E extends Exception> {
    public void accept(T var1) throws E, InterruptedException;

    default public FailableInterruptibleConsumer<T, E> andThen(FailableInterruptibleConsumer<? super T, ? extends E> after) {
        Objects.requireNonNull(after);
        return t -> {
            this.accept(t);
            after.accept(t);
        };
    }

    public static <T, E extends Exception> FailableInterruptibleConsumer<T, E> fromConsumer(final Consumer<T> consumer) {
        return new FailableInterruptibleConsumer<T, E>(){

            @Override
            public void accept(T t) throws Exception {
                consumer.accept(t);
            }
        };
    }
}

