/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.concurrent;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Future;
import org.pipecraft.infra.concurrent.FutureCompletionHandler;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class FutureCompletionLogger
extends FutureCompletionHandler<Object> {
    protected FutureCompletionLogger(Logger logger, Level successLevel, Level errLevel, String actionName, Future<?> future) {
        super(r -> FutureCompletionLogger.logSLF4J(logger, successLevel, "Completed action |" + actionName + "| successfully."), e -> FutureCompletionLogger.logSLF4JWithException(logger, errLevel, "Failed executing action |" + actionName + "|.", e), future);
    }

    public static <T> void listenTo(ListenableFuture<T> future, Logger logger, Level successLevel, Level errLevel, String actionName) {
        future.addListener((Runnable)new FutureCompletionLogger(logger, successLevel, errLevel, actionName, (Future<?>)future), MoreExecutors.directExecutor());
    }

    public static <T> void listenToError(ListenableFuture<T> future, Logger logger, Level level, String actionName) {
        FutureCompletionLogger.listenTo(future, logger, null, level, actionName);
    }

    private static void logSLF4J(Logger logger, Level level, String msg) {
        if (level != null) {
            switch (level) {
                case TRACE: {
                    logger.trace(msg);
                    break;
                }
                case DEBUG: {
                    logger.debug(msg);
                    break;
                }
                case INFO: {
                    logger.info(msg);
                    break;
                }
                case WARN: {
                    logger.warn(msg);
                    break;
                }
                case ERROR: {
                    logger.error(msg);
                }
            }
        }
    }

    private static void logSLF4JWithException(Logger logger, Level level, String msg, Throwable exception) {
        if (level != null) {
            switch (level) {
                case TRACE: {
                    logger.trace(msg, exception);
                    break;
                }
                case DEBUG: {
                    logger.debug(msg, exception);
                    break;
                }
                case INFO: {
                    logger.info(msg, exception);
                    break;
                }
                case WARN: {
                    logger.warn(msg, exception);
                    break;
                }
                case ERROR: {
                    logger.error(msg, exception);
                }
            }
        }
    }
}

