/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.concurrent;

import com.google.common.util.concurrent.Futures;
import org.pipecraft.infra.concurrent.AbstractCheckedFuture;
import org.pipecraft.infra.concurrent.CheckedFuture;

public class ImmediateFuture<V, E extends Exception>
extends AbstractCheckedFuture<V, E> {
    private ImmediateFuture(V result) {
        super(Futures.immediateFuture(result));
    }

    private ImmediateFuture(E exception) {
        super(Futures.immediateFailedFuture(exception));
    }

    @Override
    protected E map(Exception e) {
        return (E)e;
    }

    public static <V, E extends Exception> CheckedFuture<V, E> ofValue(V value) {
        return new ImmediateFuture<V, V>(value);
    }

    public static <V, E extends Exception> CheckedFuture<V, E> ofError(E exception) {
        return new ImmediateFuture<V, E>(exception);
    }
}

