/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.mutable.MutableInt;

public final class Coding {
    public static byte[] read(InputStream is, int bytesCount) throws IOException {
        byte[] buffer = new byte[bytesCount];
        IOUtils.readFully((InputStream)is, (byte[])buffer, (int)0, (int)bytesCount);
        return buffer;
    }

    public static void read(InputStream is, byte[] buffer, int offset, int bytesCount) throws IOException {
        IOUtils.readFully((InputStream)is, (byte[])buffer, (int)offset, (int)bytesCount);
    }

    public static boolean tryRead(InputStream is, byte[] buffer, int offset, int bytesCount) throws IOException {
        int bytesRead = is.readNBytes(buffer, offset, bytesCount);
        if (bytesRead == 0) {
            return false;
        }
        if (bytesRead < bytesCount) {
            throw new EOFException("Expected " + bytesCount + " bytes but got " + bytesRead);
        }
        return true;
    }

    public static byte read(InputStream is) throws IOException {
        int v = is.read();
        if (v == -1) {
            throw new EOFException("Stream ended, but expected at least one more byte.");
        }
        return (byte)v;
    }

    public static int readLittleEndian16(InputStream is) throws IOException {
        byte[] buffer = Coding.read(is, 2);
        return Coding.readLittleEndian16(buffer, 0);
    }

    public static int readLittleEndian16(byte[] src, int offset) {
        return src[offset + 0] & 0xFF | (src[offset + 1] & 0xFF) << 8;
    }

    public static byte[] getLittleEndian16AsBytes(int value) {
        byte[] res = new byte[2];
        Coding.writeLittleEndian16(value, res, 0);
        return res;
    }

    public static void writeLittleEndian16(int v, OutputStream os) throws IOException {
        os.write(v);
        os.write(v >> 8);
    }

    public static void writeLittleEndian16(int value, byte[] dest, int offset) {
        dest[offset++] = (byte)(value & 0xFF);
        dest[offset] = (byte)(value >> 8 & 0xFF);
    }

    public static int readBigEndian16(InputStream is) throws IOException {
        byte[] buffer = Coding.read(is, 2);
        return Coding.readBigEndian16(buffer, 0);
    }

    public static int readBigEndian16(byte[] src, int offset) {
        return src[offset + 1] & 0xFF | (src[offset + 0] & 0xFF) << 8;
    }

    public static byte[] getBigEndian16AsBytes(int value) {
        byte[] res = new byte[2];
        Coding.writeBigEndian16(value, res, 0);
        return res;
    }

    public static void writeBigEndian16(int v, OutputStream os) throws IOException {
        os.write(v >> 8);
        os.write(v);
    }

    public static void writeBigEndian16(int value, byte[] dest, int offset) {
        dest[offset++] = (byte)(value >> 8 & 0xFF);
        dest[offset] = (byte)(value & 0xFF);
    }

    public static int readLittleEndian32(InputStream is) throws IOException {
        byte[] buffer = Coding.read(is, 4);
        return Coding.readLittleEndian32(buffer, 0);
    }

    public static int readLittleEndian32(byte[] src, int offset) {
        return src[offset + 0] & 0xFF | (src[offset + 1] & 0xFF) << 8 | (src[offset + 2] & 0xFF) << 16 | (src[offset + 3] & 0xFF) << 24;
    }

    public static byte[] getLittleEndian32AsBytes(int value) {
        byte[] res = new byte[4];
        Coding.writeLittleEndian32(value, res, 0);
        return res;
    }

    public static void writeLittleEndian32(int v, OutputStream os) throws IOException {
        os.write(v);
        os.write(v >> 8);
        os.write(v >> 16);
        os.write(v >> 24);
    }

    public static void writeLittleEndian32(int value, byte[] dest, int offset) {
        dest[offset++] = (byte)(value & 0xFF);
        dest[offset++] = (byte)(value >> 8 & 0xFF);
        dest[offset++] = (byte)(value >> 16 & 0xFF);
        dest[offset] = (byte)(value >> 24 & 0xFF);
    }

    public static int readBigEndian32(InputStream is) throws IOException {
        byte[] buffer = Coding.read(is, 4);
        return Coding.readBigEndian32(buffer, 0);
    }

    public static int readBigEndian32(byte[] src, int offset) {
        return (src[offset + 0] & 0xFF) << 24 | (src[offset + 1] & 0xFF) << 16 | (src[offset + 2] & 0xFF) << 8 | src[offset + 3] & 0xFF;
    }

    public static byte[] getBigEndian32AsBytes(int value) {
        byte[] res = new byte[4];
        Coding.writeBigEndian32(value, res, 0);
        return res;
    }

    public static void writeBigEndian32(int v, OutputStream os) throws IOException {
        os.write(v >> 24);
        os.write(v >> 16);
        os.write(v >> 8);
        os.write(v);
    }

    public static void writeBigEndian32(int value, byte[] dest, int offset) {
        dest[offset++] = (byte)(value >> 24 & 0xFF);
        dest[offset++] = (byte)(value >> 16 & 0xFF);
        dest[offset++] = (byte)(value >> 8 & 0xFF);
        dest[offset] = (byte)(value & 0xFF);
    }

    public static long readLittleEndian64(InputStream is) throws IOException {
        byte[] buffer = Coding.read(is, 8);
        return Coding.readLittleEndian64(buffer, 0);
    }

    public static long readLittleEndian64(byte[] src, int offset) {
        return (long)(src[offset + 0] & 0xFF) | (long)(src[offset + 1] & 0xFF) << 8 | (long)(src[offset + 2] & 0xFF) << 16 | (long)(src[offset + 3] & 0xFF) << 24 | (long)(src[offset + 4] & 0xFF) << 32 | (long)(src[offset + 5] & 0xFF) << 40 | (long)(src[offset + 6] & 0xFF) << 48 | (long)(src[offset + 7] & 0xFF) << 56;
    }

    public static byte[] getLittleEndian64AsBytes(long value) {
        byte[] res = new byte[8];
        Coding.writeLittleEndian64(value, res, 0);
        return res;
    }

    public static void writeLittleEndian64(long v, OutputStream os) throws IOException {
        os.write((int)v);
        os.write((int)(v >> 8));
        os.write((int)(v >> 16));
        os.write((int)(v >> 24));
        os.write((int)(v >> 32));
        os.write((int)(v >> 40));
        os.write((int)(v >> 48));
        os.write((int)(v >> 56));
    }

    public static void writeLittleEndian64(long value, byte[] dest, int offset) {
        dest[offset++] = (byte)(value & 0xFFL);
        dest[offset++] = (byte)(value >> 8 & 0xFFL);
        dest[offset++] = (byte)(value >> 16 & 0xFFL);
        dest[offset++] = (byte)(value >> 24 & 0xFFL);
        dest[offset++] = (byte)(value >> 32 & 0xFFL);
        dest[offset++] = (byte)(value >> 40 & 0xFFL);
        dest[offset++] = (byte)(value >> 48 & 0xFFL);
        dest[offset] = (byte)(value >> 56 & 0xFFL);
    }

    public static long readBigEndian64(InputStream is) throws IOException {
        byte[] buffer = Coding.read(is, 8);
        return Coding.readBigEndian64(buffer, 0);
    }

    public static long readBigEndian64(byte[] src, int offset) {
        return (long)(src[offset + 0] & 0xFF) << 56 | (long)(src[offset + 1] & 0xFF) << 48 | (long)(src[offset + 2] & 0xFF) << 40 | (long)(src[offset + 3] & 0xFF) << 32 | (long)(src[offset + 4] & 0xFF) << 24 | (long)(src[offset + 5] & 0xFF) << 16 | (long)(src[offset + 6] & 0xFF) << 8 | (long)(src[offset + 7] & 0xFF);
    }

    public static byte[] getBigEndian64AsBytes(long value) {
        byte[] res = new byte[8];
        Coding.writeBigEndian64(value, res, 0);
        return res;
    }

    public static void writeBigEndian64(long v, OutputStream os) throws IOException {
        os.write((int)(v >> 56));
        os.write((int)(v >> 48));
        os.write((int)(v >> 40));
        os.write((int)(v >> 32));
        os.write((int)(v >> 24));
        os.write((int)(v >> 16));
        os.write((int)(v >> 8));
        os.write((int)v);
    }

    public static void writeBigEndian64(long value, byte[] dest, int offset) {
        dest[offset++] = (byte)(value >> 56 & 0xFFL);
        dest[offset++] = (byte)(value >> 48 & 0xFFL);
        dest[offset++] = (byte)(value >> 40 & 0xFFL);
        dest[offset++] = (byte)(value >> 32 & 0xFFL);
        dest[offset++] = (byte)(value >> 24 & 0xFFL);
        dest[offset++] = (byte)(value >> 16 & 0xFFL);
        dest[offset++] = (byte)(value >> 8 & 0xFFL);
        dest[offset] = (byte)(value & 0xFFL);
    }

    public static void writeUTF8(String s, OutputStream os) throws IOException {
        byte[] byteArr = s.getBytes(StandardCharsets.UTF_8);
        Coding.writeVarint32(byteArr.length, os);
        os.write(byteArr);
    }

    public static String readUTF8(InputStream is) throws IOException {
        byte[] byteArr = Coding.read(is, Coding.readVarint32(is, new MutableInt()));
        return new String(byteArr, StandardCharsets.UTF_8);
    }

    public static byte computeVarint32Size(int value) {
        if ((value & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((value & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((value & 0xFFE00000) == 0) {
            return 3;
        }
        if ((value & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static int writeVarint32(int value, byte[] dest, int offset) {
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                dest[offset++] = (byte)value;
                return offset;
            }
            dest[offset++] = (byte)(value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    public static int writeVarint32(int value, OutputStream os) throws IOException {
        byte[] buffer = new byte[5];
        int count = Coding.writeVarint32(value, buffer, 0);
        os.write(buffer, 0, count);
        return count;
    }

    public static int readVarint32(InputStream is, MutableInt length) throws IOException {
        int count;
        int res;
        block2: {
            res = 0;
            count = 0;
            do {
                int value;
                if ((value = is.read()) == -1) {
                    throw new IOException("Failed reading a varint. Expected more bytes.");
                }
                res |= (value & 0xFFFFFF7F) << 7 * count++;
                if ((value & 0x80) == 0) break block2;
            } while (count != 5);
            throw new IOException("Illegal varint. Length is greater than 5.");
        }
        length.setValue(count);
        return res;
    }

    public static int readVarint32(byte[] src, MutableInt offset) throws IOException {
        int count;
        int res;
        block2: {
            res = 0;
            count = 0;
            int pos = offset.intValue();
            do {
                if (pos == src.length) {
                    throw new IOException("Failed reading a varint. Expected more bytes.");
                }
                int value = Byte.toUnsignedInt(src[pos++]);
                res |= (value & 0xFFFFFF7F) << 7 * count++;
                if ((value & 0x80) == 0) break block2;
            } while (count != 5);
            throw new IOException("Illegal varint. Length is greater than 5.");
        }
        offset.add(count);
        return res;
    }

    public static byte[] fromHex(String hex) throws DecoderException {
        return Hex.decodeHex((char[])hex.toCharArray());
    }

    public static String toHex(byte[] raw) {
        return Hex.encodeHexString((byte[])raw);
    }
}

