/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.io;

import com.github.luben.zstd.ZstdInputStream;
import com.github.luben.zstd.ZstdOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.pipecraft.infra.concurrent.ParallelTaskProcessor;
import org.pipecraft.infra.io.Compression;
import org.pipecraft.infra.io.FileReadOptions;
import org.pipecraft.infra.io.FileWriteOptions;
import org.pipecraft.infra.sets.StreamSampler;
import org.slf4j.Logger;

public class FileUtils {
    public static final String CSV_GZ_EXTENSION = ".csv.gz";
    public static final String CSV_ZSTD_EXTENSION = ".csv.zst";
    public static final String ZSTD_EXTENSION = Compression.ZSTD.getFileExtension();
    public static final String CSV_EXTENSION = ".csv";
    public static final String NDJSON_EXTENSION = ".ndjson";
    public static final String GZ_EXTENSION = Compression.GZIP.getFileExtension();
    public static final Charset UTF8 = StandardCharsets.UTF_8;

    public static List<String> getLinesFromClasspath(String filename) throws IOException {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(filename);
        InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
        return FileUtils.getListFromReader(isr);
    }

    public static List<String> getLinesFromFile(File file, Charset charset, FileReadOptions options) throws IOException {
        BufferedReader reader = FileUtils.getReader(file, charset, options);
        return FileUtils.getListFromReader(reader);
    }

    public static List<String> getLinesFromFile(File file) throws IOException {
        return FileUtils.getLinesFromFile(file, StandardCharsets.UTF_8, new FileReadOptions());
    }

    public static Set<String> getLinesFromFileAsSet(File file, Charset charset, FileReadOptions options) throws IOException {
        BufferedReader reader = FileUtils.getReader(file, charset, options);
        return FileUtils.getSetFromReader(reader);
    }

    public static Set<String> getLinesFromFileAsSet(File file) throws IOException {
        return FileUtils.getLinesFromFileAsSet(file, StandardCharsets.UTF_8, new FileReadOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getListFromReader(Reader reader) throws IOException {
        try (BufferedReader br = new BufferedReader(reader);){
            ArrayList<String> res = new ArrayList<String>();
            String line = br.readLine();
            while (line != null) {
                res.add(line);
                line = br.readLine();
            }
            ArrayList<String> arrayList = res;
            return arrayList;
        }
    }

    public static Set<String> getSetFromReader(Reader reader) throws IOException {
        try (BufferedReader br = new BufferedReader(reader);){
            HashSet<String> res = new HashSet<String>();
            String line = br.readLine();
            while (line != null) {
                res.add(line);
                line = br.readLine();
            }
            HashSet<String> hashSet = res;
            return hashSet;
        }
    }

    public static JSONObject getJSONFromClasspath(String filename) throws IOException, ParseException {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(filename);
        return FileUtils.getJSONFromInpuStream(is);
    }

    public static List<JSONObject> getJSONListFromClasspath(String filename) throws IOException, ParseException {
        JSONParser parser = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
        try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(filename);){
            ArrayList<JSONObject> arrayList;
            block13: {
                BufferedReader br = FileUtils.getReader(is, StandardCharsets.UTF_8, new FileReadOptions());
                try {
                    ArrayList<JSONObject> res = new ArrayList<JSONObject>();
                    String line = br.readLine();
                    while (line != null) {
                        res.add((JSONObject)parser.parse(line, JSONObject.class));
                        line = br.readLine();
                    }
                    arrayList = res;
                    if (br == null) break block13;
                }
                catch (Throwable throwable) {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                br.close();
            }
            return arrayList;
        }
    }

    public static String getStringFromClasspath(String filename) throws IOException {
        try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(filename);){
            String string = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    public static JSONObject getJSONFromInpuStream(InputStream is) throws IOException, ParseException {
        JSONParser parser = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
        try (InputStream jsonStream = is;){
            JSONObject jSONObject = (JSONObject)parser.parse(jsonStream, JSONObject.class);
            return jSONObject;
        }
    }

    public static JSONObject getJSONFromFile(File file) throws IOException, ParseException {
        FileInputStream is = new FileInputStream(file);
        return FileUtils.getJSONFromInpuStream(is);
    }

    public static List<JSONObject> getJSONListFromFile(File file) throws IOException, ParseException {
        JSONParser parser = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
        try (BufferedReader br = FileUtils.getReader(file);){
            ArrayList<JSONObject> res = new ArrayList<JSONObject>();
            String line = br.readLine();
            while (line != null) {
                res.add((JSONObject)parser.parse(line, JSONObject.class));
                line = br.readLine();
            }
            ArrayList<JSONObject> arrayList = res;
            return arrayList;
        }
    }

    public static void writeJSONToFile(JSONObject json, File file) throws IOException {
        try (BufferedWriter w = FileUtils.getWriter(file);){
            w.write(json.toJSONString());
        }
    }

    public static void writeJSONListToFile(List<JSONObject> jsonList, File file) throws IOException {
        try (BufferedWriter w = FileUtils.getWriter(file);){
            for (JSONObject json : jsonList) {
                w.write(json.toJSONString());
            }
        }
    }

    public static List<List<String>> readCSV(File file) throws IOException {
        return FileUtils.readCSV(file, new FileReadOptions());
    }

    public static List<List<String>> readCSV(File file, Charset charset, FileReadOptions options) throws IOException {
        return FileUtils.readCSV(FileUtils.getReader(file, charset, options));
    }

    public static List<List<String>> readCSV(Reader csvReader) throws IOException {
        CSVFormat csvFormat = CSVFormat.DEFAULT.withNullString("null");
        ArrayList<List<String>> res = new ArrayList<List<String>>();
        try (Reader reader = csvReader;
             CSVParser parser = new CSVParser(reader, csvFormat);){
            for (CSVRecord rec : parser) {
                ArrayList<String> row = new ArrayList<String>();
                for (int i = 0; i < rec.size(); ++i) {
                    row.add(rec.get(i));
                }
                res.add(row);
            }
        }
        return res;
    }

    public static List<List<String>> readCSV(File file, FileReadOptions options) throws IOException {
        return FileUtils.readCSV(file, StandardCharsets.UTF_8, options);
    }

    public static void writeCSV(List<List<String>> lines, File f) throws IOException {
        FileUtils.writeCSV(lines, f, cells -> cells.toArray(new String[cells.size()]));
    }

    public static <T> void writeCSV(Collection<T> lines, File f, Function<T, Object[]> toLineTransformer, FileWriteOptions options) throws IOException {
        FileUtils.writeCSV(lines.iterator(), f, toLineTransformer, options, new String[0]);
    }

    public static <T> void writeCSV(Iterator<T> iterator, File file, Function<T, Object[]> toLineTransformer, FileWriteOptions options, String ... headers) throws IOException {
        CSVFormat csvFormat = CSVFormat.DEFAULT.withNullString("null");
        try (BufferedWriter bw = FileUtils.getWriter(file, options);
             CSVPrinter p = new CSVPrinter((Appendable)bw, csvFormat);){
            if (headers != null && headers.length > 0) {
                p.printRecord((Object[])headers);
            }
            while (iterator.hasNext()) {
                p.printRecord(toLineTransformer.apply(iterator.next()));
            }
        }
    }

    public static <T> void writeCSV(Collection<T> lines, File f, Function<T, Object[]> toLineTransformer) throws IOException {
        FileUtils.writeCSV(lines, f, toLineTransformer, new FileWriteOptions());
    }

    public static void writeLines(Collection<String> lines, File f, FileWriteOptions options) throws IOException {
        try (BufferedWriter bw = FileUtils.getWriter(f, options);){
            for (String line : lines) {
                bw.write(line);
                bw.newLine();
            }
        }
    }

    public static void writeLines(Collection<String> lines, File f) throws IOException {
        FileUtils.writeLines(lines, f, new FileWriteOptions());
    }

    public static File createFolder(String folderPath) throws IOException {
        File folder = new File(folderPath);
        folder.mkdirs();
        if (!folder.isDirectory()) {
            throw new IOException("Folder path " + folderPath + " doesn't point to a folder.");
        }
        return folder;
    }

    public static File createFolder(File parentFolder, String folderPath) throws IOException {
        File folder = new File(parentFolder, folderPath);
        folder.mkdirs();
        if (!folder.isDirectory()) {
            throw new IOException("Folder path " + folderPath + " doesn't point to a folder.");
        }
        return folder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sort(File[] filesToSort, File target, File tmpFolder, int memLimitMb) throws IOException, InterruptedException {
        File errFile;
        File tmpSubFolder;
        block5: {
            String srcName = filesToSort.length > 1 ? filesToSort[0].getParentFile().getName() : filesToSort[0].getName();
            Path tmpSubFolderPath = Files.createTempDirectory(tmpFolder.toPath(), "sort_" + srcName, new FileAttribute[0]);
            tmpSubFolder = tmpSubFolderPath.toFile();
            tmpSubFolder.deleteOnExit();
            errFile = null;
            Process sortProcess = null;
            try {
                ArrayList<String> args = new ArrayList<String>();
                args.add("sort");
                for (File f : filesToSort) {
                    args.add(f.getAbsolutePath());
                }
                args.add("--output");
                args.add(target.getAbsolutePath());
                args.add("--buffer-size");
                args.add(memLimitMb + "m");
                args.add("-T");
                args.add(tmpSubFolder.getAbsolutePath());
                args.add("-u");
                ProcessBuilder pb = new ProcessBuilder(args);
                pb.environment().put("LC_ALL", "C");
                errFile = File.createTempFile("sort_err", ".log", filesToSort[0].getParentFile());
                errFile.deleteOnExit();
                pb.redirectError(errFile);
                sortProcess = pb.start();
                int exitValue = sortProcess.waitFor();
                if (exitValue != 0) {
                    List l = IOUtils.readLines((InputStream)new FileInputStream(errFile), (Charset)StandardCharsets.UTF_8);
                    throw new IOException("File sorting failed with code " + exitValue + ". Description: " + StringUtils.join((Iterable)l, (String)"\n"));
                }
                if (sortProcess == null) break block5;
                sortProcess.destroyForcibly();
            }
            catch (Throwable throwable) {
                if (sortProcess != null) {
                    sortProcess.destroyForcibly();
                }
                FileUtils.deleteFiles(errFile, tmpSubFolder);
                throw throwable;
            }
        }
        FileUtils.deleteFiles(errFile, tmpSubFolder);
    }

    public static void sort(File src, File trgt, File tmpDir, int memLimit) throws IOException, InterruptedException {
        File[] filesToSort = src.isDirectory() ? src.listFiles() : new File[]{src};
        FileUtils.sort(filesToSort, trgt, tmpDir, memLimit);
    }

    public static void sort(File srcDir, FilenameFilter fnameFilter, File trgt, File tmpDir, int memLimit) throws IOException, InterruptedException {
        File[] filesToSort = srcDir.listFiles(fnameFilter);
        FileUtils.sort(filesToSort, trgt, tmpDir, memLimit);
    }

    public static int lineCount(File source, FileReadOptions options) throws IOException {
        try (BufferedReader br = FileUtils.getReader(source, options);){
            int count = 0;
            String line = br.readLine();
            while (line != null) {
                ++count;
                line = br.readLine();
            }
            int n = count;
            return n;
        }
    }

    public static int lineCount(File source) throws IOException {
        return FileUtils.lineCount(source, new FileReadOptions());
    }

    public static String joinPaths(String prefixPath, String suffixPath) {
        if (prefixPath.isEmpty()) {
            return suffixPath;
        }
        if (suffixPath.isEmpty()) {
            return prefixPath;
        }
        if (prefixPath.endsWith("/")) {
            prefixPath = prefixPath.substring(0, prefixPath.length() - 1);
        }
        if (suffixPath.startsWith("/")) {
            suffixPath = suffixPath.substring(1);
        }
        return prefixPath + "/" + suffixPath;
    }

    public static void deleteFile(File f, Logger logger) {
        if (f != null) {
            if (f.isDirectory()) {
                try {
                    org.apache.commons.io.FileUtils.deleteDirectory((File)f);
                }
                catch (IOException e) {
                    if (logger != null) {
                        logger.warn("Failed deleting temp folder: " + f.getAbsolutePath());
                    }
                }
            } else if (!f.delete() && logger != null) {
                logger.warn("Failed deleting temp file: " + f.getAbsolutePath());
            }
        }
    }

    public static void deleteFiles(Logger logger, File ... files) {
        FileUtils.deleteFiles(logger, Arrays.asList(files));
    }

    public static void deleteFiles(Logger logger, Collection<File> files) {
        for (File f : files) {
            FileUtils.deleteFile(f, logger);
        }
    }

    public static void deleteFiles(File ... files) {
        FileUtils.deleteFiles(null, files);
    }

    public static void deleteFiles(Collection<File> files) {
        FileUtils.deleteFiles(null, files);
    }

    public static void sampleLines(File srcFile, int srcSize, File dstFile, int toSample) throws IOException {
        Random rnd = new Random();
        StreamSampler sampler = new StreamSampler(rnd, srcSize, toSample);
        try (BufferedReader r = FileUtils.getReader(srcFile);
             BufferedWriter w = FileUtils.getWriter(dstFile);){
            for (int i = 0; i < srcSize; ++i) {
                String line = r.readLine();
                if (!sampler.accept()) continue;
                w.write(line);
                w.newLine();
            }
        }
    }

    public static void saveFileHead(File file, int lineCountToCopy, File outputFile) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);
             InputStreamReader isr = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(isr);
             FileOutputStream fos = new FileOutputStream(outputFile);
             OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
             BufferedWriter bw = new BufferedWriter(osw);){
            String line = br.readLine();
            for (int copiedLines = 0; line != null && copiedLines < lineCountToCopy; ++copiedLines) {
                bw.write(line);
                bw.newLine();
                line = br.readLine();
            }
        }
    }

    public static File gzip(File inFile) throws IOException {
        return FileUtils.compress(inFile, Compression.GZIP);
    }

    public static File compress(File inFile, Compression compression) throws IOException {
        return FileUtils.compress(inFile, compression, compression.getDefaultCompressionLevel());
    }

    public static File compress(File inFile, Compression compression, int compressionLevel) throws IOException {
        if (compression == Compression.NONE) {
            return inFile;
        }
        byte[] buffer = new byte[8192];
        File outFile = new File(inFile.getParentFile(), inFile.getName() + compression.getFileExtension());
        try (BufferedInputStream bis = FileUtils.getInputStream(inFile, new FileReadOptions());
             FileOutputStream os = new FileOutputStream(outFile);
             OutputStream cos = FileUtils.getCompressionOutputStream(os, compression, compressionLevel);){
            int count = ((InputStream)bis).read(buffer);
            while (count != -1) {
                cos.write(buffer, 0, count);
                count = ((InputStream)bis).read(buffer);
            }
        }
        return outFile;
    }

    public static void compressAll(File folder, Compression compression, int parallelism) throws IOException {
        FileUtils.compressAll(folder, compression, compression.getDefaultCompressionLevel(), parallelism);
    }

    public static void compressAll(File folder, Compression compression, int compressionLevel, int parallelism) throws IOException {
        if (compression == Compression.NONE) {
            throw new IllegalArgumentException("Must specify a valid compression");
        }
        try {
            ParallelTaskProcessor.runFailable(Arrays.asList(folder.listFiles()), parallelism, f -> {
                FileUtils.compress(f, compression, compressionLevel);
                FileUtils.deleteFiles(f);
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
    }

    public static File gunzip(File inFile) throws IOException {
        return FileUtils.decompress(inFile, Compression.GZIP);
    }

    public static File decompress(File inFile, Compression compression) throws IOException {
        byte[] buffer = new byte[8192];
        Object targetName = inFile.getName();
        targetName = ((String)targetName).endsWith(compression.getFileExtension()) ? ((String)targetName).substring(0, ((String)targetName).length() - compression.getFileExtension().length()) : (String)targetName + ".decompressed";
        File outFile = new File(inFile.getParentFile(), (String)targetName);
        try (BufferedInputStream is = FileUtils.getInputStream(inFile, new FileReadOptions().setCompression(compression));
             BufferedOutputStream os = FileUtils.getOutputStream(outFile, new FileWriteOptions());){
            int count = ((InputStream)is).read(buffer);
            while (count != -1) {
                ((OutputStream)os).write(buffer, 0, count);
                count = ((InputStream)is).read(buffer);
            }
        }
        return outFile;
    }

    public static void decompressAll(File folder, Compression compression, int parallelism) throws IOException {
        if (compression == Compression.NONE) {
            throw new IllegalArgumentException("Must specify a valid compression");
        }
        try {
            ParallelTaskProcessor.runFailable(Arrays.asList(folder.listFiles()), parallelism, f -> {
                FileUtils.decompress(f, compression);
                FileUtils.deleteFiles(f);
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean areIdentical(File file1, File file2) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[WHILELOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static File createTempFile(String prefix, String suffix, File folder) throws IOException {
        File f = File.createTempFile(prefix, suffix, folder);
        f.deleteOnExit();
        return f;
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return FileUtils.createTempFile(prefix, suffix, null);
    }

    public static File createUniqueFile(String prefix, String suffix, File folder) throws IOException {
        return File.createTempFile(prefix, suffix, folder);
    }

    public static File createUniqueFile(String prefix, String suffix) throws IOException {
        return File.createTempFile(prefix, suffix);
    }

    public static File createTempFolder(String prefix, File parentFolder) throws IOException {
        File res = FileUtils.createUniqueFolder(prefix, parentFolder);
        res.deleteOnExit();
        return res;
    }

    public static File getSystemDefaultTmpFolder() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    public static File createUniqueFolder(String prefix, File parentFolder) throws IOException {
        Path path = Files.createTempDirectory(parentFolder.toPath(), prefix, new FileAttribute[0]);
        File res = path.toFile();
        return res;
    }

    public static File createTempFolder(String prefix) throws IOException {
        File res = FileUtils.createUniqueFolder(prefix);
        res.deleteOnExit();
        return res;
    }

    public static File createUniqueFolder(String prefix) throws IOException {
        Path path = Files.createTempDirectory(prefix, new FileAttribute[0]);
        File res = path.toFile();
        return res;
    }

    public static BufferedOutputStream getOutputStream(OutputStream os, FileWriteOptions options) throws IOException {
        os = FileUtils.getCompressionOutputStream(os, options.getCompression(), options.getCompressionLevel());
        return new BufferedOutputStream(os, options.getBufferSize());
    }

    public static BufferedOutputStream getOutputStream(File f, FileWriteOptions options) throws IOException {
        if (options.isTemp()) {
            f.deleteOnExit();
        }
        FileOutputStream os = new FileOutputStream(f, options.isAppend());
        return FileUtils.getOutputStream(os, options);
    }

    public static BufferedInputStream getInputStream(InputStream is, FileReadOptions options) throws IOException {
        is = FileUtils.getCompressionInputStream(is, options.getCompression());
        return new BufferedInputStream(is, options.getBufferSize());
    }

    public static BufferedInputStream getInputStream(File f, FileReadOptions options) throws IOException {
        FileInputStream is = new FileInputStream(f);
        return FileUtils.getInputStream(is, options);
    }

    public static BufferedWriter getWriter(OutputStream os, Charset charset, FileWriteOptions options) throws IOException {
        os = FileUtils.getCompressionOutputStream(os, options.getCompression(), options.getCompressionLevel());
        OutputStreamWriter osw = new OutputStreamWriter(os, charset);
        return new BufferedWriter(osw, options.getBufferSize());
    }

    public static BufferedWriter getWriter(File f, Charset charset, FileWriteOptions options) throws IOException {
        if (options.isTemp()) {
            f.deleteOnExit();
        }
        FileOutputStream os = new FileOutputStream(f, options.isAppend());
        return FileUtils.getWriter(os, charset, options);
    }

    public static BufferedWriter getWriter(File f, FileWriteOptions options) throws IOException {
        return FileUtils.getWriter(f, StandardCharsets.UTF_8, options);
    }

    public static BufferedWriter getWriter(File f, Charset charset) throws IOException {
        return FileUtils.getWriter(f, charset, new FileWriteOptions());
    }

    public static BufferedWriter getWriter(File f) throws IOException {
        return FileUtils.getWriter(f, StandardCharsets.UTF_8, new FileWriteOptions());
    }

    public static InputStream getCompressionInputStream(InputStream is, Compression compression) throws IOException {
        switch (compression) {
            case GZIP: {
                return new GZIPInputStream(is);
            }
            case ZSTD: {
                return new ZstdInputStream(is);
            }
            case NONE: {
                return is;
            }
            case LZ4: {
                throw new IllegalArgumentException("Compression type LZ4 not supported yet");
            }
        }
        throw new IllegalArgumentException("Compression type is unknown: " + compression);
    }

    public static OutputStream getCompressionOutputStream(OutputStream os, Compression compression) throws IOException {
        return FileUtils.getCompressionOutputStream(os, compression, compression.getDefaultCompressionLevel());
    }

    public static OutputStream getCompressionOutputStream(OutputStream os, Compression compression, final int compressionLevel) throws IOException {
        switch (compression) {
            case GZIP: {
                return new GZIPOutputStream(os){
                    {
                        super(arg0);
                        this.def.setLevel(compressionLevel);
                    }
                };
            }
            case ZSTD: {
                return new ZstdOutputStream(os, compressionLevel);
            }
            case NONE: {
                return os;
            }
            case LZ4: {
                throw new IllegalArgumentException("Compression type LZ4 not supported yet");
            }
        }
        throw new IllegalArgumentException("Compression type is unknown: " + compression);
    }

    public static BufferedReader getReader(InputStream is, Charset charset, FileReadOptions options) throws IOException {
        is = FileUtils.getCompressionInputStream(is, options.getCompression());
        InputStreamReader isr = new InputStreamReader(is, charset);
        return new BufferedReader(isr, options.getBufferSize());
    }

    public static BufferedReader getReader(InputStream is) throws IOException {
        return FileUtils.getReader(is, StandardCharsets.UTF_8, new FileReadOptions());
    }

    public static BufferedReader getReader(File f, Charset charset, FileReadOptions options) throws IOException {
        FileInputStream is = new FileInputStream(f);
        return FileUtils.getReader(is, charset, options);
    }

    public static BufferedReader getReader(File f, FileReadOptions options) throws IOException {
        return FileUtils.getReader(f, StandardCharsets.UTF_8, options);
    }

    public static BufferedReader getReader(File f, Charset charset) throws IOException {
        return FileUtils.getReader(f, charset, new FileReadOptions());
    }

    public static BufferedReader getReader(File f) throws IOException {
        return FileUtils.getReader(f, StandardCharsets.UTF_8, new FileReadOptions());
    }

    public static InputStream getInputStreamFromClasspath(String path) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return loader.getResourceAsStream(path);
    }

    public static BufferedReader getReaderFromClasspath(String path, Charset charset, FileReadOptions options) throws IOException {
        InputStream is = FileUtils.getInputStreamFromClasspath(path);
        is = FileUtils.getCompressionInputStream(is, options.getCompression());
        InputStreamReader isr = new InputStreamReader(is, charset);
        return new BufferedReader(isr, options.getBufferSize());
    }

    public static BufferedReader getReaderFromClasspath(String path, FileReadOptions options) throws IOException {
        return FileUtils.getReaderFromClasspath(path, StandardCharsets.UTF_8, options);
    }

    public static BufferedReader getReaderFromClasspath(String path, Charset charset) throws IOException {
        return FileUtils.getReaderFromClasspath(path, charset, new FileReadOptions());
    }

    public static BufferedReader getReaderFromClasspath(String path) throws IOException {
        return FileUtils.getReaderFromClasspath(path, StandardCharsets.UTF_8, new FileReadOptions());
    }

    public static void validateFolderNotEmpty(File folder) throws IOException {
        File[] files = folder.listFiles();
        if (files == null || files.length == 0) {
            throw new IOException("Folder " + folder.getName() + " is empty");
        }
    }

    public static String getExtension(String name) {
        int ind = name.indexOf(46);
        if (ind == -1) {
            return null;
        }
        return name.substring(ind);
    }

    public static String removeExtension(String name) {
        int ind = name.indexOf(46);
        if (ind != -1) {
            name = name.substring(0, ind);
        }
        return name;
    }

    public static String getDotlessExtension(String name) {
        int ind = name.lastIndexOf(46);
        if (ind == -1) {
            return null;
        }
        return name.substring(ind);
    }

    public static String removeDotlessExtension(String name) {
        int ind = name.lastIndexOf(46);
        if (ind != -1) {
            name = name.substring(0, ind);
        }
        return name;
    }

    public static String removeCSVExtension(String fileName) {
        if (fileName.endsWith(CSV_GZ_EXTENSION)) {
            fileName = FileUtils.truncateEnd(fileName, CSV_GZ_EXTENSION.length());
        } else if (fileName.endsWith(CSV_EXTENSION)) {
            fileName = FileUtils.truncateEnd(fileName, CSV_EXTENSION.length());
        } else if (fileName.endsWith(ZSTD_EXTENSION)) {
            fileName = FileUtils.truncateEnd(fileName, ZSTD_EXTENSION.length());
        }
        return fileName;
    }

    public static void copyFile(File src, File dst) throws IOException {
        org.apache.commons.io.FileUtils.copyFile((File)src, (File)dst);
    }

    public static void copyFileToFolder(File src, File dstFolder) throws IOException {
        org.apache.commons.io.FileUtils.copyFile((File)src, (File)new File(dstFolder, src.getName()));
    }

    public static long getTotalSizeRecursive(File folder) {
        long total = 0L;
        for (File f : folder.listFiles()) {
            if (f.isFile()) {
                total += f.length();
                continue;
            }
            if (!f.isDirectory()) continue;
            total += FileUtils.getTotalSizeRecursive(f);
        }
        return total;
    }

    private static String truncateEnd(String source, int charsToRemove) {
        return source.substring(0, source.length() - charsToRemove);
    }

    public static void close(Closeable ... closeables) throws IOException {
        FileUtils.close(Arrays.asList(closeables));
    }

    public static void close(Collection<? extends Closeable> closeables) throws IOException {
        ArrayList<IOException> errors = new ArrayList<IOException>();
        for (Closeable closeable : closeables) {
            try {
                FileUtils.close(closeable);
            }
            catch (IOException e) {
                errors.add(e);
            }
        }
        if (!errors.isEmpty()) {
            IOException exception = new IOException("Could not bulk close all closeables");
            errors.forEach(exception::addSuppressed);
            throw exception;
        }
    }

    public static void close(Closeable closeable) throws IOException {
        if (closeable != null) {
            closeable.close();
        }
    }

    public static void closeSilently(Closeable ... closeables) {
        FileUtils.closeSilently(Arrays.asList(closeables));
    }

    public static void closeSilently(Collection<? extends Closeable> closeables) {
        for (Closeable closeable : closeables) {
            try {
                FileUtils.close(closeable);
            }
            catch (IOException iOException) {}
        }
    }
}

