/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.io;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import net.minidev.json.JSONObject;
import org.pipecraft.infra.concurrent.FailableInterruptibleRunnable;
import org.pipecraft.infra.concurrent.FailableInterruptibleSupplier;
import org.pipecraft.infra.monitoring.JsonMonitorable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Retrier
implements JsonMonitorable {
    private static final Logger logger = LoggerFactory.getLogger(Retrier.class);
    private static final int DEFAULT_INITIAL_WAIT_TIME_MS = 1000;
    private static final double DEFAULT_WAIT_TIME_FACTOR = 2.0;
    private static final int DEFAULT_TIMES_TO_TRY = 4;
    private final AtomicInteger invocationsCount = new AtomicInteger();
    private final AtomicInteger failedInvocationsCount = new AtomicInteger();
    private final AtomicInteger triesCount = new AtomicInteger();
    private final int initialWaitTimeMs;
    private final double waitTimeFactor;
    private final int timesToTry;

    public Retrier(int initialWaitTimeMs, double waitTimeFactor, int timesToTry) {
        this.initialWaitTimeMs = initialWaitTimeMs;
        this.waitTimeFactor = waitTimeFactor;
        this.timesToTry = timesToTry;
    }

    public <E extends Exception> void run(FailableInterruptibleRunnable<E> toRun) throws E, InterruptedException {
        this.run(toRun, (E e) -> false);
    }

    public <T, E extends Exception> T run(FailableInterruptibleSupplier<T, E> toRun) throws E, InterruptedException {
        return this.run(toRun, (E e) -> false);
    }

    public <E extends Exception> void run(FailableInterruptibleRunnable<E> toRun, Predicate<E> terminalErrorPredicate) throws E, InterruptedException {
        this.run(() -> {
            toRun.run();
            return null;
        }, terminalErrorPredicate);
    }

    public <E extends Exception> void run(FailableInterruptibleRunnable<E> toRun, Collection<Class<? extends E>> terminalErrorTypes) throws E, InterruptedException {
        this.run(toRun, (E e) -> Retrier.isAnyOf(e, terminalErrorTypes));
    }

    public <T, E extends Exception> T run(FailableInterruptibleSupplier<T, E> toRun, Collection<Class<? extends E>> terminalErrorTypes) throws E, InterruptedException {
        return this.run(toRun, (E e) -> Retrier.isAnyOf(e, terminalErrorTypes));
    }

    public <T, E extends Exception> T run(FailableInterruptibleSupplier<T, E> toRun, Predicate<E> terminalErrorPredicate) throws E, InterruptedException {
        int attempts = 0;
        this.invocationsCount.incrementAndGet();
        boolean success = false;
        while (true) {
            try {
                ++attempts;
                this.triesCount.incrementAndGet();
                T result = toRun.get();
                success = true;
                T t = result;
                return t;
            }
            catch (Error | InterruptedException | RuntimeException x) {
                throw x;
            }
            catch (Exception e) {
                if (terminalErrorPredicate.test(e)) {
                    throw e;
                }
                logger.debug("Task failed after " + attempts + " attempt/s.", (Throwable)e);
                if (attempts >= this.timesToTry) {
                    throw e;
                }
                TimeUnit.MILLISECONDS.sleep((long)((double)this.initialWaitTimeMs * Math.pow(this.waitTimeFactor, attempts - 1)));
                continue;
            }
            break;
        }
        finally {
            if (!success) {
                this.failedInvocationsCount.incrementAndGet();
            }
        }
    }

    public static <E extends Exception> void runWithDefaults(FailableInterruptibleRunnable<E> toRun, Predicate<E> terminalErrorPredicate) throws E, InterruptedException {
        Retrier retrier = new Retrier(1000, 2.0, 4);
        retrier.run(toRun, terminalErrorPredicate);
    }

    public static <T, E extends Exception> T runWithDefaults(FailableInterruptibleSupplier<T, E> toRun, Predicate<E> terminalErrorPredicate) throws E, InterruptedException {
        Retrier retrier = new Retrier(1000, 2.0, 4);
        return retrier.run(toRun, terminalErrorPredicate);
    }

    public static <E extends Exception> void runWithDefaults(FailableInterruptibleRunnable<E> toRun, Collection<Class<? extends E>> terminalErrorTypes) throws E, InterruptedException {
        Retrier retrier = new Retrier(1000, 2.0, 4);
        retrier.run(toRun, terminalErrorTypes);
    }

    public static <T, E extends Exception> T runWithDefaults(FailableInterruptibleSupplier<T, E> toRun, Collection<Class<? extends E>> terminalErrorTypes) throws E, InterruptedException {
        Retrier retrier = new Retrier(1000, 2.0, 4);
        return retrier.run(toRun, terminalErrorTypes);
    }

    public static <E extends Exception> void runWithDefaults(FailableInterruptibleRunnable<E> toRun) throws E, InterruptedException {
        Retrier retrier = new Retrier(1000, 2.0, 4);
        retrier.run(toRun);
    }

    public static <T, E extends Exception> T runWithDefaults(FailableInterruptibleSupplier<T, E> toRun) throws E, InterruptedException {
        Retrier retrier = new Retrier(1000, 2.0, 4);
        return retrier.run(toRun);
    }

    public static <E extends Exception> void run(FailableInterruptibleRunnable<E> toRun, Predicate<E> terminalErrorPredicate, int initialWaitTimeMs, double waitTimeFactor, int timesToTry) throws E, InterruptedException {
        Retrier retrier = new Retrier(initialWaitTimeMs, waitTimeFactor, timesToTry);
        retrier.run(toRun, terminalErrorPredicate);
    }

    public static <T, E extends Exception> T run(FailableInterruptibleSupplier<T, E> toRun, Predicate<E> terminalErrorPredicate, int initialWaitTimeMs, double waitTimeFactor, int timesToTry) throws E, InterruptedException {
        Retrier retrier = new Retrier(initialWaitTimeMs, waitTimeFactor, timesToTry);
        return retrier.run(toRun, terminalErrorPredicate);
    }

    public static <E extends Exception> void run(FailableInterruptibleRunnable<E> toRun, Collection<Class<? extends E>> terminalErrorTypes, int initialWaitTimeMs, double waitTimeFactor, int timesToTry) throws E, InterruptedException {
        Retrier retrier = new Retrier(initialWaitTimeMs, waitTimeFactor, timesToTry);
        retrier.run(toRun, terminalErrorTypes);
    }

    public static <T, E extends Exception> T run(FailableInterruptibleSupplier<T, E> toRun, Collection<Class<? extends E>> terminalErrorTypes, int initialWaitTimeMs, double waitTimeFactor, int timesToTry) throws E, InterruptedException {
        Retrier retrier = new Retrier(initialWaitTimeMs, waitTimeFactor, timesToTry);
        return retrier.run(toRun, terminalErrorTypes);
    }

    public static <E extends Exception> void run(FailableInterruptibleRunnable<E> toRun, int initialWaitTimeMs, double waitTimeFactor, int timesToTry) throws E, InterruptedException {
        Retrier retrier = new Retrier(initialWaitTimeMs, waitTimeFactor, timesToTry);
        retrier.run(toRun);
    }

    public static <T, E extends Exception> T run(FailableInterruptibleSupplier<T, E> toRun, int initialWaitTimeMs, double waitTimeFactor, int timesToTry) throws E, InterruptedException {
        Retrier retrier = new Retrier(initialWaitTimeMs, waitTimeFactor, timesToTry);
        return retrier.run(toRun);
    }

    private static <E extends Exception> boolean isAnyOf(E e, Collection<Class<? extends E>> terminalErrorTypes) {
        for (Class<E> exceptionType : terminalErrorTypes) {
            if (!exceptionType.isInstance(e)) continue;
            return true;
        }
        return false;
    }

    @Override
    public JSONObject getOwnMetrics() {
        JSONObject json = new JSONObject();
        json.put((Object)"invocations", (Object)this.invocationsCount.get());
        json.put((Object)"failedInvocations", (Object)this.failedInvocationsCount.get());
        json.put((Object)"tries", (Object)this.triesCount.get());
        return json;
    }

    @Override
    public Map<String, ? extends JsonMonitorable> getChildren() {
        return Collections.emptyMap();
    }
}

