/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.math;

import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;

public class FastRandom
extends Random {
    private static final long serialVersionUID = 1L;
    private static final AtomicLong seedUniquifier = new AtomicLong(8682522807148012L);
    private static final long multiplier = 25214903917L;
    private static final long addend = 11L;
    private static final long mask = 0xFFFFFFFFFFFFL;
    private long seed;

    public FastRandom() {
        this(FastRandom.seedUniquifier() ^ System.nanoTime());
    }

    private static long seedUniquifier() {
        long next;
        long current;
        while (!seedUniquifier.compareAndSet(current = seedUniquifier.get(), next = current * 181783497276652981L)) {
        }
        return next;
    }

    public FastRandom(long seed) {
        this.seed = (seed ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
    }

    @Override
    protected int next(int bits) {
        long nextseed;
        long oldseed = this.seed;
        this.seed = nextseed = oldseed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return (int)(nextseed >>> 48 - bits);
    }
}

