/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.math;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.function.Function;

public class StaticJobScheduler<J> {
    private final List<J> jobs;
    private final Function<J, Double> weightFunction;

    public StaticJobScheduler(Collection<J> jobs, Function<J, Double> weightFunction) {
        this.jobs = new ArrayList<J>(jobs);
        this.weightFunction = weightFunction;
        this.jobs.sort(Comparator.comparing(weightFunction).reversed());
    }

    public List<Collection<J>> schedule(int workerCount) {
        ArrayList<Collection<J>> partition = new ArrayList<Collection<J>>(workerCount);
        PriorityQueue<Worker> loads = new PriorityQueue<Worker>();
        for (int w = 0; w < workerCount; ++w) {
            loads.add(new Worker(w));
            partition.add(new ArrayList());
        }
        if (workerCount > 0) {
            for (J job : this.jobs) {
                Worker w = (Worker)loads.poll();
                w.addWeight(this.weightFunction.apply(job));
                loads.add(w);
                partition.get(w.id).add(job);
            }
        }
        return partition;
    }

    private static class Worker
    implements Comparable<Worker> {
        private final int id;
        private double totalJobWeight;

        public Worker(int id) {
            this.id = id;
        }

        public void addWeight(double w) {
            this.totalJobWeight += w;
        }

        @Override
        public int compareTo(Worker o) {
            return Double.compare(this.totalJobWeight, o.totalJobWeight);
        }
    }
}

