/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.monitoring.collectors;

import java.util.Collections;
import java.util.Map;
import net.minidev.json.JSONObject;
import org.pipecraft.infra.monitoring.JsonMonitorable;

public final class ActionStats
implements JsonMonitorable {
    private final long completedCount;
    private final long totalDurationMicros;

    public ActionStats(long completedCount, long totalDurationMicros) {
        this.completedCount = completedCount;
        this.totalDurationMicros = totalDurationMicros;
    }

    public long getCompletedCount() {
        return this.completedCount;
    }

    public long getTotalDurationMicros() {
        return this.totalDurationMicros;
    }

    public long getAvgActionDuration() {
        if (this.completedCount == 0L) {
            return -1L;
        }
        return this.totalDurationMicros / this.completedCount;
    }

    public String toString() {
        return this.getOwnMetrics().toJSONString();
    }

    @Override
    public JSONObject getOwnMetrics() {
        JSONObject res = new JSONObject();
        res.put((Object)"completed", (Object)this.completedCount);
        res.put((Object)"totalMicros", (Object)this.totalDurationMicros);
        res.put((Object)"avgMicros", (Object)(this.completedCount > 0L ? this.totalDurationMicros / this.completedCount : 0L));
        return res;
    }

    @Override
    public Map<String, ? extends JsonMonitorable> getChildren() {
        return Collections.emptyMap();
    }
}

