/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.monitoring.collectors;

import java.util.EnumMap;
import java.util.Map;
import org.pipecraft.infra.monitoring.collectors.AbstractActionStatsCollector;
import org.pipecraft.infra.monitoring.collectors.ActionStatsMap;

public class BlockingActionStatsCollector<E extends Enum<E>>
extends AbstractActionStatsCollector<E> {
    private int running;
    private final EnumMap<E, StatsPair> categoryStats;
    private final Object lock = new Object();

    public BlockingActionStatsCollector(Class<E> categoriesEnumClass) {
        super(categoriesEnumClass);
        EnumMap<E, StatsPair> stats = new EnumMap<E, StatsPair>(categoriesEnumClass);
        for (Enum category : (Enum[])categoriesEnumClass.getEnumConstants()) {
            stats.put(category, new StatsPair());
        }
        this.categoryStats = stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void innerStart() {
        Object object = this.lock;
        synchronized (object) {
            ++this.running;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void innerEnd(E category, long duration) {
        Object object = this.lock;
        synchronized (object) {
            --this.running;
            StatsPair pair = this.categoryStats.get(category);
            ++pair.count;
            pair.totalDurationMicros += duration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startAndEnd(E category) {
        Object object = this.lock;
        synchronized (object) {
            StatsPair pair = this.categoryStats.get(category);
            ++pair.count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRunning() {
        Object object = this.lock;
        synchronized (object) {
            return this.running;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCompletedCount(E category) {
        StatsPair statsPair = this.categoryStats.get(category);
        Object object = this.lock;
        synchronized (object) {
            return statsPair.count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTotalDurationMicros(E category) {
        StatsPair statsPair = this.categoryStats.get(category);
        Object object = this.lock;
        synchronized (object) {
            return statsPair.totalDurationMicros;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActionStatsMap<E> getAll() {
        Object object = this.lock;
        synchronized (object) {
            ActionStatsMap<Enum> stats = new ActionStatsMap<Enum>(this.categoriesEnumClass);
            stats.setRunningCount(this.getRunning());
            for (Map.Entry<E, StatsPair> entry : this.categoryStats.entrySet()) {
                Enum category = (Enum)entry.getKey();
                StatsPair pair = this.categoryStats.get(category);
                stats.setCategoryStats((Enum)entry.getKey(), pair.count, pair.totalDurationMicros);
            }
            return stats;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.running = 0;
            for (StatsPair pair : this.categoryStats.values()) {
                pair.count = 0L;
                pair.totalDurationMicros = 0L;
            }
        }
    }

    private static class StatsPair {
        public long count;
        public long totalDurationMicros;

        private StatsPair() {
        }
    }
}

