/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.monitoring.collectors;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import net.minidev.json.JSONObject;
import org.pipecraft.infra.monitoring.JsonMonitorable;
import org.pipecraft.infra.monitoring.collectors.EnumEventStatsMap;
import org.pipecraft.infra.monitoring.collectors.EventStatsMap;

public class EventsCollector<E extends Enum<E>>
implements JsonMonitorable {
    private final EnumMap<E, AtomicLong> categoryCounters;
    private final Class<E> categoriesEnumClass;

    public EventsCollector(Class<E> categoriesEnumClass) {
        this.categoriesEnumClass = categoriesEnumClass;
        EnumMap<E, AtomicLong> stats = new EnumMap<E, AtomicLong>(categoriesEnumClass);
        for (Enum category : (Enum[])categoriesEnumClass.getEnumConstants()) {
            stats.put(category, new AtomicLong());
        }
        this.categoryCounters = stats;
    }

    public void countEvent(E category) {
        AtomicLong counter = this.categoryCounters.get(category);
        counter.incrementAndGet();
    }

    public long getCount(E category) {
        return this.categoryCounters.get(category).get();
    }

    public EventStatsMap<E> getAll() {
        EnumEventStatsMap<Enum> stats = new EnumEventStatsMap<Enum>(this.categoriesEnumClass);
        for (Map.Entry<E, AtomicLong> entry : this.categoryCounters.entrySet()) {
            Enum category = (Enum)entry.getKey();
            AtomicLong counter = this.categoryCounters.get(category);
            stats.setCategoryCounts((Enum)entry.getKey(), counter.get());
        }
        return stats;
    }

    public void clear() {
        for (AtomicLong counter : this.categoryCounters.values()) {
            counter.set(0L);
        }
    }

    @Override
    public JSONObject getOwnMetrics() {
        return this.getAll().toJson();
    }

    public Map<String, JsonMonitorable> getChildren() {
        return Collections.emptyMap();
    }
}

