/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.monitoring.graphite;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.pipecraft.infra.monitoring.graphite.GraphiteException;

public class GraphiteClient {
    private static final String EMPTY_ROOT = "";
    private static final String METRIC_PATH_SEPARATOR = ".";
    private final String host;
    private final int port;
    private final String rootPath;

    public GraphiteClient(String host, int port, String rootPath) {
        this.host = host;
        this.port = port;
        this.rootPath = rootPath;
    }

    public void sendMetric(String key, Number value) throws GraphiteException {
        this.sendMetric(key, value, this.getCurrentTimestamp());
    }

    public void sendMetrics(Map<String, ? extends Number> metrics) throws GraphiteException {
        this.sendMetrics(metrics, this.getCurrentTimestamp());
    }

    public void sendMetrics(Map<String, ? extends Number> metrics, long timestamp) throws GraphiteException {
        try (Socket socket = new Socket(this.host, this.port);
             PrintWriter out = new PrintWriter(socket.getOutputStream(), true);){
            for (Map.Entry<String, ? extends Number> metric : metrics.entrySet()) {
                out.printf("%s %s %d%n", this.getMetricName(metric), metric.getValue(), timestamp);
            }
        }
        catch (UnknownHostException e) {
            throw new GraphiteException("Unknown host: " + this.host);
        }
        catch (IOException e) {
            throw new GraphiteException("Error while writing data to graphite: " + e.getMessage(), e);
        }
    }

    private String getMetricName(Map.Entry<String, ? extends Number> metric) {
        String prefix = this.rootPath == null ? EMPTY_ROOT : this.rootPath + METRIC_PATH_SEPARATOR;
        return prefix + metric.getKey();
    }

    public void sendMetric(final String key, final Number value, long timestamp) throws GraphiteException {
        this.sendMetrics((Map<String, ? extends Number>)new HashMap<String, Number>(){
            {
                this.put(key, value);
            }
        }, timestamp);
    }

    protected long getCurrentTimestamp() {
        return System.currentTimeMillis() / 1000L;
    }
}

