/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.monitoring.quantile;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;
import org.pipecraft.infra.monitoring.quantile.ConcurrentQuantileEstimator;
import org.pipecraft.infra.monitoring.quantile.MultiQuantileDigest;
import org.pipecraft.infra.monitoring.quantile.QuantileDigest;

public class SlidingWindowQuantileDigest
implements ConcurrentQuantileEstimator {
    private static final double COMPRESSION_INFLATION_DEFAULT = 1.5;
    private static final double COMPRESSION_DEFAULT = 100.0;
    private final int journalingIntervalMillis;
    private final double compression;
    private final MultiQuantileDigest liveDigest;
    private final QuantileDigest[] journal;
    private volatile int journalPosition = 0;
    private final Object lock = new Object();

    public SlidingWindowQuantileDigest(int liveDigestCount, int journalingIntervalMillis, int capacity, ScheduledExecutorService executorService) {
        this(liveDigestCount, 100.0, 1.5, journalingIntervalMillis, capacity, executorService);
    }

    public SlidingWindowQuantileDigest(int liveDigestCount, double compression, int journalingIntervalMillis, int capacity, ScheduledExecutorService executorService) {
        this(liveDigestCount, compression, 1.5, journalingIntervalMillis, capacity, executorService);
    }

    public SlidingWindowQuantileDigest(int liveDigestCount, double compression, double compressionInflationMultiplier, int journalingIntervalMillis, int capacity, ScheduledExecutorService executorService) {
        this.journalingIntervalMillis = journalingIntervalMillis;
        this.compression = compression;
        this.liveDigest = new MultiQuantileDigest(liveDigestCount, compression * compressionInflationMultiplier);
        this.journal = new QuantileDigest[capacity];
        for (int i = 0; i < this.journal.length; ++i) {
            this.journal[i] = new QuantileDigest(compression * compressionInflationMultiplier);
        }
        if (journalingIntervalMillis != -1) {
            executorService.scheduleAtFixedRate(this::publishToJournal, journalingIntervalMillis, journalingIntervalMillis, TimeUnit.MILLISECONDS);
        }
    }

    public double getCompression() {
        return this.compression;
    }

    public int getJournalingIntervalMillis() {
        return this.journalingIntervalMillis;
    }

    public int getCapacity() {
        return this.journal.length;
    }

    public QuantileDigest summarize() {
        return this.summarize(this.journal.length);
    }

    public QuantileDigest summarize(int lookback) {
        Validate.isTrue((lookback <= this.journal.length ? 1 : 0) != 0, (String)"lookback must be less than or equal to capacity", (Object[])new Object[0]);
        QuantileDigest summary = new QuantileDigest(this.compression);
        int startPos = (this.journalPosition - lookback + this.journal.length) % this.journal.length;
        for (int i = 0; i < lookback; ++i) {
            summary.add(this.journal[(startPos + i) % this.journal.length]);
        }
        summary.add(this.liveDigest.summarize());
        return summary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishToJournal() {
        Object object = this.lock;
        synchronized (object) {
            int currentPos = this.journalPosition % this.journal.length;
            ++this.journalPosition;
            this.journal[currentPos].reset();
            this.journal[currentPos].add(this.liveDigest.reset());
        }
    }

    @Override
    public double quantile(double q) {
        return this.summarize().quantile(q);
    }

    @Override
    public List<Double> quantile(List<Double> qs) {
        QuantileDigest digest = this.summarize();
        ArrayList<Double> quantiles = new ArrayList<Double>(qs.size());
        for (Double q : qs) {
            quantiles.add(digest.quantile(q));
        }
        return quantiles;
    }

    @Override
    public long size() {
        return this.summarize().size();
    }

    @Override
    public double cdf(double x) {
        return this.summarize().cdf(x);
    }

    @Override
    public List<Double> cdf(List<Double> coords) {
        QuantileDigest digest = this.summarize();
        ArrayList<Double> cdfs = new ArrayList<Double>(coords.size());
        for (Double x : coords) {
            cdfs.add(digest.cdf(x));
        }
        return cdfs;
    }

    @Override
    public boolean tryAdd(double x, int w) {
        return this.liveDigest.tryAdd(x, w);
    }

    @Override
    public void add(double x, int w) {
        this.liveDigest.add(x, w);
    }
}

