/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.monitoring.sliding;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.pipecraft.infra.monitoring.sliding.SlidingWindow;

public class EventRateSlidingWindow
extends SlidingWindow<Void, AtomicInteger, Long> {
    public EventRateSlidingWindow(int slotsCount, int slotTime, TimeUnit slotTimeUnit, ScheduledExecutorService ex) {
        super(slotsCount, slotTime, slotTimeUnit, ex);
    }

    @Override
    protected void newEvent(Void event, AtomicInteger rec) {
        rec.incrementAndGet();
    }

    @Override
    protected AtomicInteger newRecord() {
        return new AtomicInteger();
    }

    protected AtomicInteger[] newRecordArray(int size) {
        return new AtomicInteger[size];
    }

    @Override
    protected void clearRecord(AtomicInteger record) {
        record.set(0);
    }

    protected Long query(AtomicInteger[] records) {
        long res = 0L;
        for (AtomicInteger counter : records) {
            res += (long)counter.get();
        }
        return res;
    }

    public float query(TimeUnit timeUnit) {
        long res = (Long)this.query();
        long millisInUnit = timeUnit.toMillis(1L);
        float unitsInWindow = (float)this.getWindowTimeSpanMs() / (float)millisInUnit;
        return (float)res / unitsInWindow;
    }
}

