/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.monitoring.sliding;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public abstract class SlidingWindow<E, R, Q> {
    private final R[] slots;
    private volatile int pos;
    private final ScheduledFuture<?> timePulseHandler;
    private final int slotTime;
    private final TimeUnit slotTimeUnit;

    public SlidingWindow(int slotsCount, int slotTime, TimeUnit slotTimeUnit, ScheduledExecutorService ex) {
        R[] slotsTmp = this.newRecordArray(slotsCount);
        for (int i = 0; i < slotsTmp.length; ++i) {
            slotsTmp[i] = this.newRecord();
        }
        this.slots = slotsTmp;
        this.slotTime = slotTime;
        this.slotTimeUnit = slotTimeUnit;
        this.timePulseHandler = ex.scheduleAtFixedRate(new TimePulseTask(), slotTime, slotTime, slotTimeUnit);
    }

    public void newEvent(E event) {
        R rec = this.slots[this.pos];
        this.newEvent(event, rec);
    }

    protected abstract void newEvent(E var1, R var2);

    protected abstract R newRecord();

    protected abstract R[] newRecordArray(int var1);

    protected abstract void clearRecord(R var1);

    public Q query() {
        return this.query(this.slots.length);
    }

    public Q query(int lookback) {
        if (lookback == this.slots.length) {
            return this.query(this.slots);
        }
        int startPos = (this.pos - lookback + 1 + this.slots.length) % this.slots.length;
        R[] records = this.newRecordArray(lookback);
        for (int i = 0; i < lookback; ++i) {
            records[i] = this.slots[(startPos + i) % this.slots.length];
        }
        return this.query(records);
    }

    protected abstract Q query(R[] var1);

    public void shutdown() {
        this.timePulseHandler.cancel(false);
    }

    public int getSlotTime() {
        return this.slotTime;
    }

    public TimeUnit getSlotTimeUnit() {
        return this.slotTimeUnit;
    }

    public long getWindowTimeSpanMs() {
        return (long)this.getSlotsCount() * this.getSlotTimeUnit().toMillis(this.getSlotTime());
    }

    public int getSlotsCount() {
        return this.slots.length;
    }

    protected R getRecord(int pos) {
        return this.slots[pos];
    }

    private class TimePulseTask
    implements Runnable {
        private TimePulseTask() {
        }

        @Override
        public void run() {
            int nextPos = (SlidingWindow.this.pos + 1) % SlidingWindow.this.slots.length;
            SlidingWindow.this.clearRecord(SlidingWindow.this.getRecord(nextPos));
            SlidingWindow.this.pos = nextPos;
        }
    }
}

