/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.net;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class HostPort
implements Comparable<HostPort> {
    private final String host;
    private final int port;

    public HostPort(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public HostPort(String hostPort) {
        try {
            String[] parts = hostPort.split(":");
            if (parts.length != 2) {
                throw new IllegalArgumentException("Argument should be in the format <HOST>:<PORT>, while got " + hostPort);
            }
            this.host = parts[0];
            this.port = Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("The given port is not a number: " + hostPort, e);
        }
    }

    public static List<HostPort> getHostPorts(String hostsArg) {
        if (hostsArg.isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.stream(hostsArg.split(",")).map(HostPort::new).collect(Collectors.toList());
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return this.host + ":" + this.port;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof HostPort)) {
            return false;
        }
        HostPort others = (HostPort)o;
        return others.getPort() == this.getPort() && others.getHost().equals(this.getHost());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + this.port;
        return result;
    }

    @Override
    public int compareTo(HostPort o) {
        int last = this.host.compareTo(o.getHost());
        return last == 0 ? Integer.compare(this.port, o.port) : last;
    }
}

