/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.storage;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pipecraft.infra.storage.StoragePath;

public class PathUtils {
    private static final String PROTOCOL_SUFFIX = "://";
    private static final String PATH_SEPARATOR = "/";
    private static final Pattern FULLY_QUALIFIED_PATH_PATTERN = Pattern.compile("(?<protocol>[a-zA-Z0-9]*)://(?<bucketName>[a-z0-9_\\-.]+)/(?<key>.*)");

    public static String buildPath(String ... parts) {
        return PathUtils.buildPath(false, parts);
    }

    public static String buildFullPath(String protocol, String ... parts) {
        return protocol + PROTOCOL_SUFFIX + PathUtils.buildPath(false, parts);
    }

    public static String buildPath(boolean isFolder, String ... parts) {
        String path = String.join((CharSequence)PATH_SEPARATOR, parts).concat(isFolder ? PATH_SEPARATOR : "").replaceAll("/{2,}", PATH_SEPARATOR);
        if (path.startsWith(PATH_SEPARATOR)) {
            path = path.substring(1);
        }
        return path;
    }

    public static String buildPath(String protocol, boolean isFolder, String ... parts) {
        return protocol + PROTOCOL_SUFFIX + PathUtils.buildPath(isFolder, parts);
    }

    public static String getLastPathPart(String path) {
        String[] pathParts = path.split(PATH_SEPARATOR);
        return pathParts[pathParts.length - 1];
    }

    public static String getParentPath(String path) {
        return path.substring(0, path.lastIndexOf(PATH_SEPARATOR) + 1);
    }

    public static String getProtocolFromFullyQualifiedPath(String fullyQualifiedPath) {
        Matcher matcher = FULLY_QUALIFIED_PATH_PATTERN.matcher(fullyQualifiedPath);
        if (matcher.matches()) {
            return matcher.group("protocol");
        }
        return null;
    }

    public static String getBucketNameFromFullyQualifiedPath(String fullyQualifiedPath) {
        Matcher matcher = FULLY_QUALIFIED_PATH_PATTERN.matcher(fullyQualifiedPath);
        if (matcher.matches()) {
            return matcher.group("bucketName");
        }
        return null;
    }

    public static String getKeyFromFullyQualifiedPath(String fullyQualifiedPath) {
        Matcher matcher = FULLY_QUALIFIED_PATH_PATTERN.matcher(fullyQualifiedPath);
        if (matcher.matches()) {
            return matcher.group("key");
        }
        return null;
    }

    public static StoragePath parseFullyQualifiedPath(String fullyQualifiedPath) {
        Matcher matcher = FULLY_QUALIFIED_PATH_PATTERN.matcher(fullyQualifiedPath);
        if (matcher.matches()) {
            return new StoragePath(matcher.group("protocol"), matcher.group("bucketName"), matcher.group("key"));
        }
        return null;
    }
}

