/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.storage;

import org.pipecraft.infra.storage.PathUtils;

public class StoragePath {
    private final String protocol;
    private final String bucket;
    private final String path;

    public StoragePath(String protocol, String bucket, String path) {
        this.protocol = protocol;
        this.bucket = bucket;
        this.path = path;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getPath() {
        return this.path;
    }

    public String toString() {
        return PathUtils.buildFullPath(this.protocol, this.bucket, this.path);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bucket == null ? 0 : this.bucket.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StoragePath other = (StoragePath)obj;
        if (this.bucket == null ? other.bucket != null : !this.bucket.equals(other.bucket)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        return !(this.protocol == null ? other.protocol != null : !this.protocol.equals(other.protocol));
    }
}

