/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.storage.local;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.pipecraft.infra.io.FileReadOptions;
import org.pipecraft.infra.io.FileUtils;
import org.pipecraft.infra.io.SizedInputStream;
import org.pipecraft.infra.storage.Bucket;

public class LocalDiskBucket
extends Bucket<File> {
    private final File bucketFolder;

    LocalDiskBucket(File baseFolder, String bucketName) {
        super(bucketName);
        this.bucketFolder = new File(baseFolder, bucketName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, InputStream input, long length, String contentType, boolean isPublic, boolean allowOverride) throws IOException {
        this.validateNotFolderPath(key);
        File file = this.getFileRefGenPath(key);
        File tmpFile = FileUtils.createTempFile("upload_tmp", ".tmp");
        try (BufferedInputStream is = FileUtils.getInputStream(input, new FileReadOptions());
             FileOutputStream os = new FileOutputStream(tmpFile);){
            IOUtils.copy((InputStream)is, (OutputStream)os, (int)65536);
            if (!allowOverride) {
                Files.move(tmpFile.toPath(), file.toPath(), new CopyOption[0]);
            } else {
                Files.move(tmpFile.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        finally {
            tmpFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyToAnotherBucket(String fromKey, String toBucket, String toKey) throws IOException {
        File src = this.getFileRef(fromKey);
        File dst = this.getFileRefGenPath(toBucket, toKey);
        File tmpFile = FileUtils.createTempFile("copy_tmp", ".tmp");
        try {
            FileUtils.copyFile(src, tmpFile);
            Files.move(tmpFile.toPath(), dst.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            tmpFile.delete();
        }
    }

    @Override
    public void delete(File f) throws IOException {
        this.validateBelongsToBucket(f);
        if (!f.delete()) {
            throw new IOException("Failed deleting file " + f.getAbsolutePath());
        }
        File parent = f.getParentFile();
        while (!parent.equals(this.bucketFolder) && parent.list().length == 0) {
            FileUtils.deleteFiles(parent);
            parent = parent.getParentFile();
        }
    }

    @Override
    public void get(File meta, File output) throws IOException {
        this.validateBelongsToBucket(meta);
        FileUtils.copyFile(meta, output);
    }

    @Override
    public SizedInputStream getAsStream(File f, int chunkSize) throws IOException {
        this.validateBelongsToBucket(f);
        return new SizedInputStream(new FileInputStream(f), f.length());
    }

    @Override
    public OutputStream getOutputStream(String key, int chunkSize) throws IOException {
        this.validateNotFolderPath(key);
        File tmpFile = FileUtils.createTempFile("outputstream_tmp", ".tmp");
        return new AtomicFileCreatorOutputStream(tmpFile, this.getFileRefGenPath(key));
    }

    @Override
    public boolean exists(String key) throws IOException {
        File ref = this.getFileRef(key);
        return ref.isFile();
    }

    @Override
    public Iterator<File> listObjects(String folderPath, boolean recursive) throws IOException {
        Path parent = this.getFileRef(folderPath).toPath();
        try {
            return Files.walk(parent, recursive ? Integer.MAX_VALUE : 1, new FileVisitOption[0]).filter(p -> !p.equals(parent)).map(Path::toFile).iterator();
        }
        catch (NoSuchFileException e) {
            return Collections.emptyIterator();
        }
    }

    @Override
    public File getObjectMetadata(String key) throws IOException {
        File f = this.getFileRef(key);
        if (!f.exists() || f.isDirectory()) {
            throw new FileNotFoundException("File " + key + " not found in bucket " + this.getBucketName());
        }
        return f;
    }

    @Override
    public String getPath(File f) {
        try {
            String fullPath = f.getCanonicalPath();
            String bucketPath = this.bucketFolder.getCanonicalPath() + File.separator;
            if (!fullPath.startsWith(bucketPath)) {
                throw new IllegalArgumentException("Given file (" + f.getAbsolutePath() + ") doesn't belong to the bucket " + this.getBucketName());
            }
            return FilenameUtils.separatorsToUnix((String)fullPath.substring(bucketPath.length())) + (f.isDirectory() ? "/" : "");
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to canonize paths", e);
        }
    }

    @Override
    public long getLength(File f) {
        if (f.isDirectory()) {
            return 0L;
        }
        return f.length();
    }

    @Override
    public Long getLastUpdated(File objMetadata) {
        if (objMetadata.isDirectory()) {
            return null;
        }
        return objMetadata.lastModified();
    }

    @Override
    public URL generateSignedUrl(String key, String contentType, int expirationSeconds, boolean isPublicRead) {
        throw new UnsupportedOperationException();
    }

    @Override
    public URL generateReadOnlyUrl(String key, int expirationSeconds) {
        throw new UnsupportedOperationException();
    }

    @Override
    public URL generateResumableSignedUrlForUpload(String key, String contentType, int expirationSeconds, Long maxContentLengthInBytes, boolean isPublic) {
        throw new UnsupportedOperationException();
    }

    @Override
    public File compose(List<String> paths, String composedFilePath, boolean removeComprisingFiles) throws IOException {
        File outFile = this.getFileRefGenPath(composedFilePath);
        if (outFile.isDirectory()) {
            throw new IOException("Illegal path: '" + composedFilePath + "'. Expected a file path.");
        }
        File tmpFile = FileUtils.createTempFile("compose_temp", ".tmp");
        try (FileOutputStream os = new FileOutputStream(tmpFile);){
            for (String inputPath : paths) {
                File inFile = this.getFileRef(inputPath);
                try (FileInputStream is = new FileInputStream(inFile);){
                    IOUtils.copy((InputStream)is, (OutputStream)os, (int)50000);
                }
            }
        }
        Files.move(tmpFile.toPath(), outFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        if (removeComprisingFiles) {
            List<String> toDelete = paths.stream().filter(path -> !path.equals(composedFilePath)).collect(Collectors.toList());
            try {
                this.deleteAllInterruptibly(toDelete, Runtime.getRuntime().availableProcessors());
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException("Interrupted while deleting compose source files");
            }
        }
        return outFile;
    }

    private File getFileRef(String path) {
        return new File(this.bucketFolder, path);
    }

    private File getFileRef(String bucket, String path) {
        return new File(new File(this.bucketFolder.getParent(), bucket), path);
    }

    private File getFileRefGenPath(String path) {
        return this.getFileRefGenPath(this.getBucketName(), path);
    }

    private File getFileRefGenPath(String bucket, String path) {
        File res = this.getFileRef(bucket, path);
        res.getParentFile().mkdirs();
        return res;
    }

    private void validateBelongsToBucket(File f) {
        this.getPath(f);
    }

    private static class AtomicFileCreatorOutputStream
    extends FilterOutputStream {
        private final File targetFile;
        private final File tmpFile;
        private boolean closed;

        public AtomicFileCreatorOutputStream(File tmpFile, File targetFile) throws FileNotFoundException {
            super(new FileOutputStream(tmpFile));
            this.tmpFile = tmpFile;
            this.targetFile = targetFile;
        }

        @Override
        public void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                try {
                    super.close();
                    Files.move(this.tmpFile.toPath(), this.targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                finally {
                    this.tmpFile.delete();
                }
            }
        }
    }
}

