/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.async.inter;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.pipecraft.pipes.async.AsyncPipe;
import org.pipecraft.pipes.async.AsyncPipeListener;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.utils.PipeUtils;

public class AsyncHeadPipe<T>
extends AsyncPipe<T> {
    private final AsyncPipe<T> input;
    private final AtomicInteger remainingToRead;
    private final AtomicInteger completed;
    private final int totalToRead;
    private volatile boolean done;

    public AsyncHeadPipe(AsyncPipe<T> input, int count) {
        this.input = input;
        this.totalToRead = count;
        this.remainingToRead = new AtomicInteger(count);
        this.completed = new AtomicInteger();
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        this.input.setListener(new AsyncPipeListener<T>(){

            @Override
            public void next(T item) throws PipeException, InterruptedException {
                if (AsyncHeadPipe.this.remainingToRead.get() <= 0) {
                    return;
                }
                if (AsyncHeadPipe.this.remainingToRead.getAndDecrement() > 0) {
                    AsyncHeadPipe.this.notifyNext(item);
                    if (AsyncHeadPipe.this.completed.incrementAndGet() == AsyncHeadPipe.this.totalToRead) {
                        new Thread(() -> PipeUtils.close(AsyncHeadPipe.this.input)).start();
                        AsyncHeadPipe.this.notifyDone();
                    }
                }
            }

            @Override
            public void done() throws InterruptedException {
                AsyncHeadPipe.this.notifyDone();
                AsyncHeadPipe.this.done = true;
            }

            @Override
            public void error(PipeException e) throws InterruptedException {
                AsyncHeadPipe.this.notifyError(e);
            }
        });
        this.input.start();
    }

    @Override
    public float getProgress() {
        if (this.done) {
            return 1.0f;
        }
        return 1.0f - (float)this.remainingToRead.get() / (float)this.totalToRead;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.input.close();
    }
}

