/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.async.inter;

import java.io.IOException;
import org.pipecraft.infra.concurrent.FailableFunction;
import org.pipecraft.pipes.async.AsyncPipe;
import org.pipecraft.pipes.async.AsyncPipeListener;
import org.pipecraft.pipes.exceptions.PipeException;

public class AsyncMapPipe<S, T>
extends AsyncPipe<T> {
    private final AsyncPipe<S> input;
    private final FailableFunction<? super S, T, PipeException> mapFunction;

    public AsyncMapPipe(AsyncPipe<S> input, FailableFunction<? super S, T, PipeException> mapFunction) {
        this.input = input;
        this.mapFunction = mapFunction;
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        this.input.setListener(new AsyncPipeListener<S>(){

            @Override
            public void next(S item) throws PipeException, InterruptedException {
                AsyncMapPipe.this.notifyNext(AsyncMapPipe.this.mapFunction.apply(item));
            }

            @Override
            public void done() throws InterruptedException {
                AsyncMapPipe.this.notifyDone();
            }

            @Override
            public void error(PipeException e) throws InterruptedException {
                AsyncMapPipe.this.notifyError(e);
            }
        });
        this.input.start();
    }

    @Override
    public float getProgress() {
        return this.input.getProgress();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.input.close();
    }
}

