/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.async.inter;

import java.io.IOException;
import java.util.function.Consumer;
import org.apache.commons.lang3.mutable.MutableInt;
import org.pipecraft.pipes.async.AsyncPipe;
import org.pipecraft.pipes.async.AsyncPipeListener;
import org.pipecraft.pipes.exceptions.PipeException;

public class AsyncProgressPipe<T>
extends AsyncPipe<T> {
    private final AsyncPipe<T> inputPipe;
    private final Consumer<Integer> callback;
    private final ThreadLocal<MutableInt> counter;
    private final int sampleRate;
    private final Object lock = new Object();
    private volatile int progressPct;

    public AsyncProgressPipe(AsyncPipe<T> inputPipe, int sampleRate, Consumer<Integer> callback) {
        this.inputPipe = inputPipe;
        this.callback = callback;
        this.sampleRate = sampleRate;
        this.counter = ThreadLocal.withInitial(MutableInt::new);
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        this.inputPipe.setListener(new AsyncPipeListener<T>(){

            @Override
            public void next(T item) throws PipeException, InterruptedException {
                if (AsyncProgressPipe.this.counter.get().incrementAndGet() % AsyncProgressPipe.this.sampleRate == 0) {
                    AsyncProgressPipe.this.update((int)(100.0f * AsyncProgressPipe.this.inputPipe.getProgress()));
                }
                AsyncProgressPipe.this.notifyNext(item);
            }

            @Override
            public void done() throws InterruptedException {
                AsyncProgressPipe.this.update(100);
                AsyncProgressPipe.this.notifyDone();
            }

            @Override
            public void error(PipeException e) throws InterruptedException {
                AsyncProgressPipe.this.notifyError(e);
            }
        });
        this.callback.accept(0);
        this.inputPipe.start();
    }

    @Override
    public float getProgress() {
        return this.inputPipe.getProgress();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.inputPipe.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(int newProgressPct) {
        if (newProgressPct > this.progressPct) {
            Object object = this.lock;
            synchronized (object) {
                if (newProgressPct > this.progressPct) {
                    this.progressPct = newProgressPct;
                    this.callback.accept(newProgressPct);
                }
            }
        }
    }
}

