/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.async.source;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.pipecraft.pipes.async.AsyncPipe;
import org.pipecraft.pipes.exceptions.PipeException;

public class AsyncSeqGenPipe<T>
extends AsyncPipe<T> {
    private final long count;
    private final Function<Long, T> generator;
    private final int threadCount;
    private final AtomicLong producedCount = new AtomicLong();
    private volatile boolean closeRequested;
    private final CountDownLatch closeLatch = new CountDownLatch(1);

    public AsyncSeqGenPipe(long count, Function<Long, T> generator, int threadCount) {
        this.count = count;
        this.generator = generator;
        this.threadCount = threadCount;
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        new Thread(() -> {
            try {
                Thread[] threads = new Thread[this.threadCount];
                for (int t = 0; t < this.threadCount; ++t) {
                    int start = t;
                    Thread thread = new Thread(() -> {
                        try {
                            for (long i = (long)start; i < this.count; i += (long)this.threadCount) {
                                if (this.closeRequested) {
                                    return;
                                }
                                T item = this.generator.apply(i);
                                this.notifyNext(item);
                                this.producedCount.incrementAndGet();
                            }
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    });
                    thread.start();
                    threads[t] = thread;
                }
                for (Thread t : threads) {
                    t.join();
                }
                this.notifyDone();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.closeLatch.countDown();
            }
        }).start();
    }

    @Override
    public float getProgress() {
        return (float)this.producedCount.get() / (float)this.count;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.closeRequested = true;
        try {
            this.closeLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

