/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.serialization;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.pipecraft.infra.io.FileWriteOptions;
import org.pipecraft.pipes.serialization.ByteArrayEncoder;
import org.pipecraft.pipes.serialization.ItemEncoder;

public interface EncoderFactory<T> {
    public ItemEncoder<T> newEncoder(OutputStream var1, FileWriteOptions var2) throws IOException;

    default public ItemEncoder<T> newEncoder(OutputStream os) throws IOException {
        return this.newEncoder(os, new FileWriteOptions());
    }

    default public ByteArrayEncoder<T> newByteArrayEncoder() {
        return item -> {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try (ItemEncoder<Object> encoder = this.newEncoder(os);){
                encoder.encode(item);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return os.toByteArray();
        };
    }
}

