/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.serialization;

import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.Message;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.pipecraft.infra.io.FileReadOptions;
import org.pipecraft.infra.io.FileUtils;
import org.pipecraft.pipes.exceptions.ValidationPipeException;
import org.pipecraft.pipes.serialization.DecoderFactory;
import org.pipecraft.pipes.serialization.ItemDecoder;

public class ProtobufDecoder<T extends Message>
implements ItemDecoder<T> {
    private static final ExtensionRegistryLite EMPTY_REGISTRY = ExtensionRegistryLite.getEmptyRegistry();
    private final Class<T> clazz;
    private final Method parseMethod;
    private final InputStream is;
    private final ExtensionRegistryLite registry;

    public ProtobufDecoder(Class<T> clazz, InputStream is) throws IOException {
        this(clazz, is, new FileReadOptions(), EMPTY_REGISTRY);
    }

    public ProtobufDecoder(Class<T> clazz, InputStream is, FileReadOptions options, ExtensionRegistryLite registry) throws IOException {
        this.clazz = clazz;
        this.registry = registry;
        try {
            this.parseMethod = clazz.getMethod("parseDelimitedFrom", InputStream.class, ExtensionRegistryLite.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException("Couldn't find or use the parseFrom() method for the proto type: " + clazz.getSimpleName());
        }
        this.is = FileUtils.getInputStream(is, options);
    }

    @Override
    public T decode() throws IOException, ValidationPipeException {
        try {
            return (T)((Message)this.parseMethod.invoke(this.clazz, this.is, this.registry));
        }
        catch (InvocationTargetException e) {
            throw new ValidationPipeException(e.getCause());
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    public static <R extends Message> DecoderFactory<R> getFactory(Class<R> clazz) {
        return new Factory<R>(clazz, EMPTY_REGISTRY);
    }

    public static <R extends Message> DecoderFactory<R> getFactory(Class<R> clazz, ExtensionRegistryLite registry) {
        return new Factory<R>(clazz, registry);
    }

    private static class Factory<R extends Message>
    implements DecoderFactory<R> {
        private final Class<R> clazz;
        private final ExtensionRegistryLite registry;

        public Factory(Class<R> clazz, ExtensionRegistryLite registry) {
            this.clazz = clazz;
            this.registry = registry;
        }

        @Override
        public ItemDecoder<R> newDecoder(InputStream is, FileReadOptions options) throws IOException {
            return new ProtobufDecoder<R>(this.clazz, is, options, this.registry);
        }
    }
}

