/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.serialization;

import com.google.protobuf.Message;
import java.io.IOException;
import java.io.OutputStream;
import org.pipecraft.infra.io.FileUtils;
import org.pipecraft.infra.io.FileWriteOptions;
import org.pipecraft.pipes.serialization.EncoderFactory;
import org.pipecraft.pipes.serialization.ItemEncoder;

public class ProtobufEncoder<T extends Message>
implements ItemEncoder<T> {
    private final OutputStream os;

    public ProtobufEncoder(OutputStream os) throws IOException {
        this(os, new FileWriteOptions());
    }

    public ProtobufEncoder(OutputStream os, FileWriteOptions options) throws IOException {
        this.os = FileUtils.getOutputStream(os, options);
    }

    @Override
    public void encode(T item) throws IOException {
        item.writeDelimitedTo(this.os);
    }

    @Override
    public void close() throws IOException {
        this.os.close();
    }

    public static <R extends Message> EncoderFactory<R> getFactory() {
        return new Factory();
    }

    private static class Factory<R extends Message>
    implements EncoderFactory<R> {
        private Factory() {
        }

        @Override
        public ItemEncoder<R> newEncoder(OutputStream os, FileWriteOptions options) throws IOException {
            return new ProtobufEncoder(os, options);
        }
    }
}

