/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.serialization;

import java.io.IOException;
import java.io.InputStream;
import org.pipecraft.infra.concurrent.FailableFunction;
import org.pipecraft.infra.io.FileReadOptions;
import org.pipecraft.pipes.exceptions.ValidationPipeException;
import org.pipecraft.pipes.serialization.AbstractInputStreamItemDecoder;
import org.pipecraft.pipes.serialization.ByteArrayDecoder;
import org.pipecraft.pipes.serialization.DecoderFactory;
import org.pipecraft.pipes.serialization.ItemDecoder;

public class SimpleDecoderFactory<T>
implements DecoderFactory<T> {
    private final FailableFunction<InputStream, T, ? extends IOException> statelessDecoder;
    private final ByteArrayDecoder<T> byteArrDecoder;

    public SimpleDecoderFactory(FailableFunction<InputStream, T, ? extends IOException> statelessDecoder) {
        this.statelessDecoder = statelessDecoder;
        this.byteArrDecoder = DecoderFactory.super.newByteArrayDecoder();
    }

    public SimpleDecoderFactory(FailableFunction<InputStream, T, ? extends IOException> statelessDecoder, ByteArrayDecoder<T> byteArrDecoder) {
        this.statelessDecoder = statelessDecoder;
        this.byteArrDecoder = byteArrDecoder;
    }

    @Override
    public ItemDecoder<T> newDecoder(InputStream is, FileReadOptions readOptions) throws IOException {
        return new Decoder(is, readOptions);
    }

    @Override
    public ByteArrayDecoder<T> newByteArrayDecoder() {
        return this.byteArrDecoder;
    }

    private class Decoder
    extends AbstractInputStreamItemDecoder<T> {
        public Decoder(InputStream is, FileReadOptions readOptions) throws IOException {
            super(is, readOptions);
        }

        @Override
        public T decode() throws IOException, ValidationPipeException {
            return SimpleDecoderFactory.this.statelessDecoder.apply(this.is);
        }
    }
}

