/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.serialization;

import java.io.IOException;
import java.io.OutputStream;
import org.pipecraft.infra.concurrent.FailableBiConsumer;
import org.pipecraft.infra.io.FileWriteOptions;
import org.pipecraft.pipes.serialization.AbstractOutputStreamItemEncoder;
import org.pipecraft.pipes.serialization.ByteArrayEncoder;
import org.pipecraft.pipes.serialization.EncoderFactory;
import org.pipecraft.pipes.serialization.ItemEncoder;

public class SimpleEncoderFactory<T>
implements EncoderFactory<T> {
    private final FailableBiConsumer<T, OutputStream, ? extends IOException> statelessEncoder;
    private final ByteArrayEncoder<T> byteArrEncoder;

    public SimpleEncoderFactory(FailableBiConsumer<T, OutputStream, ? extends IOException> statelessEncoder) {
        this.statelessEncoder = statelessEncoder;
        this.byteArrEncoder = EncoderFactory.super.newByteArrayEncoder();
    }

    public SimpleEncoderFactory(FailableBiConsumer<T, OutputStream, ? extends IOException> statelessEncoder, ByteArrayEncoder<T> byteArrEncoder) {
        this.statelessEncoder = statelessEncoder;
        this.byteArrEncoder = byteArrEncoder;
    }

    @Override
    public ItemEncoder<T> newEncoder(OutputStream os, FileWriteOptions writeOptions) throws IOException {
        return new Encoder(os, writeOptions);
    }

    @Override
    public ByteArrayEncoder<T> newByteArrayEncoder() {
        return this.byteArrEncoder;
    }

    private class Encoder
    extends AbstractOutputStreamItemEncoder<T> {
        public Encoder(OutputStream os, FileWriteOptions writeOptions) throws IOException {
            super(os, writeOptions);
        }

        @Override
        public void encode(T value) throws IOException {
            SimpleEncoderFactory.this.statelessEncoder.accept(value, this.os);
        }
    }
}

