/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.serialization;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import org.pipecraft.infra.io.FileUtils;
import org.pipecraft.infra.io.FileWriteOptions;
import org.pipecraft.pipes.serialization.ByteArrayEncoder;
import org.pipecraft.pipes.serialization.EncoderFactory;
import org.pipecraft.pipes.serialization.ItemEncoder;

public class TxtEncoderFactory<T>
implements EncoderFactory<T> {
    public static final TxtEncoderFactory<String> IDENTITY = new TxtEncoderFactory<String>(x -> x);
    private final Function<T, String> itemTextualizer;
    private final Charset charset;

    public TxtEncoderFactory(Function<T, String> itemTextualizer, Charset charset) {
        this.itemTextualizer = itemTextualizer;
        this.charset = charset;
    }

    public TxtEncoderFactory(Function<T, String> itemTextualizer) {
        this(itemTextualizer, StandardCharsets.UTF_8);
    }

    public TxtEncoderFactory() {
        this(Object::toString, StandardCharsets.UTF_8);
    }

    @Override
    public ItemEncoder<T> newEncoder(OutputStream os, FileWriteOptions writeOptions) throws IOException {
        return new Encoder(os, writeOptions);
    }

    @Override
    public ByteArrayEncoder<T> newByteArrayEncoder() {
        return item -> {
            String itemAsText = this.itemTextualizer.apply(item);
            return itemAsText.getBytes(this.charset);
        };
    }

    private class Encoder
    implements ItemEncoder<T> {
        private final BufferedWriter writer;

        public Encoder(OutputStream os, FileWriteOptions options) throws IOException {
            this.writer = FileUtils.getWriter(os, TxtEncoderFactory.this.charset, options);
        }

        @Override
        public void encode(T item) throws IOException {
            String itemAsText = TxtEncoderFactory.this.itemTextualizer.apply(item);
            this.writer.write(itemAsText);
            this.writer.newLine();
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }
    }
}

