/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.sync.inter;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Supplier;
import org.pipecraft.pipes.async.AsyncPipe;
import org.pipecraft.pipes.async.AsyncPipeListener;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.exceptions.QueuePipeException;
import org.pipecraft.pipes.sync.Pipe;
import org.pipecraft.pipes.utils.QueueItem;

public class AsyncToSyncPipe<T>
implements Pipe<T> {
    private final AsyncPipe<T> inputPipe;
    private final BlockingQueue<QueueItem<T>> queue;
    private boolean done;

    public AsyncToSyncPipe(AsyncPipe<T> inputPipe, BlockingQueue<QueueItem<T>> queue) {
        this.inputPipe = inputPipe;
        this.queue = queue;
    }

    public AsyncToSyncPipe(AsyncPipe<T> inputPipe, int queueCapacity) {
        this(inputPipe, new LinkedBlockingQueue<QueueItem<T>>(queueCapacity));
    }

    @Deprecated
    public AsyncToSyncPipe(AsyncPipe<T> inputPipe, BlockingQueue<T> queue, Supplier<T> markerFactory) {
        this.inputPipe = inputPipe;
        this.queue = queue;
    }

    @Deprecated
    public AsyncToSyncPipe(AsyncPipe<T> inputPipe, int queueCapacity, Supplier<T> markerFactory) {
        this(inputPipe, new LinkedBlockingQueue(queueCapacity), markerFactory);
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        Listener l = new Listener();
        this.inputPipe.setListener(l);
        this.inputPipe.start();
    }

    @Override
    public float getProgress() {
        return this.inputPipe.getProgress();
    }

    @Override
    public void close() throws IOException {
        this.inputPipe.close();
    }

    @Override
    public T next() throws PipeException, InterruptedException {
        if (this.done) {
            return null;
        }
        QueueItem<T> itemW = this.queue.take();
        if (itemW.isSuccessfulEndOfData()) {
            this.done = true;
            return null;
        }
        Throwable e = itemW.getThrowable();
        if (e != null) {
            this.done = true;
            throw new QueuePipeException("Error signaled by queue producer", e);
        }
        return itemW.getItem();
    }

    @Override
    public T peek() throws PipeException {
        try {
            QueueItem itemW;
            while ((itemW = (QueueItem)this.queue.peek()) == null) {
                Thread.sleep(10L);
            }
            if (itemW.isSuccessfulEndOfData()) {
                return null;
            }
            Throwable e = itemW.getThrowable();
            if (e != null) {
                throw new QueuePipeException("Error signaled by queue producer", e);
            }
            return itemW.getItem();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    private class Listener
    implements AsyncPipeListener<T> {
        private Listener() {
        }

        @Override
        public void next(T item) throws PipeException, InterruptedException {
            AsyncToSyncPipe.this.queue.put(QueueItem.of(item));
        }

        @Override
        public void done() throws InterruptedException {
            AsyncToSyncPipe.this.queue.put(QueueItem.end());
        }

        @Override
        public void error(PipeException e) throws InterruptedException {
            AsyncToSyncPipe.this.queue.put(QueueItem.error(e));
        }
    }
}

