/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.sync.inter;

import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.pipecraft.infra.concurrent.FailableFunction;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.exceptions.ValidationPipeException;
import org.pipecraft.pipes.sync.Pipe;

public class CSVMapperPipe<T>
implements Pipe<T> {
    private static final char DEFAULT_DELIMITER = ',';
    private final Pipe<String> input;
    private final boolean hasHeader;
    private volatile String[] columnNames;
    private final FailableFunction<Map<String, String>, T, PipeException> rowConverter;
    private T next;
    private final CSVParser csvParser;

    public CSVMapperPipe(Pipe<String> input, char delimiter, boolean hasHeader, String[] columnNames, FailableFunction<Map<String, String>, T, PipeException> rowConverter) {
        if (columnNames == null && !hasHeader) {
            throw new IllegalArgumentException("Must eather specify column names, or require a header in the input pipe");
        }
        this.input = input;
        this.hasHeader = hasHeader;
        this.csvParser = new CSVParserBuilder().withSeparator(delimiter).build();
        this.columnNames = columnNames;
        this.rowConverter = rowConverter;
    }

    public CSVMapperPipe(Pipe<String> input, boolean hasHeader, String[] columnNames, FailableFunction<Map<String, String>, T, PipeException> rowConverter) {
        this(input, ',', hasHeader, columnNames, rowConverter);
    }

    public CSVMapperPipe(Pipe<String> input, FailableFunction<Map<String, String>, T, PipeException> rowConverter) {
        this(input, ',', true, null, rowConverter);
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        this.input.start();
        if (this.hasHeader) {
            String header = this.input.next();
            if (header == null) {
                throw new ValidationPipeException("Expected CSV header");
            }
            String[] headerColumns = this.splitRow(header);
            if (this.columnNames == null) {
                this.columnNames = headerColumns;
            } else if (this.columnNames.length != headerColumns.length) {
                throw new ValidationPipeException("Number of columns in input is " + headerColumns.length + ", but expected " + this.columnNames.length);
            }
        }
        HashSet<String> columnNameSet = new HashSet<String>();
        for (String colName : this.columnNames) {
            if (columnNameSet.add(colName)) continue;
            throw new ValidationPipeException("Duplicate column found: " + colName);
        }
        this.prepareNext();
    }

    @Override
    public T next() throws PipeException, InterruptedException {
        T toReturn = this.next;
        this.prepareNext();
        return toReturn;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    private void prepareNext() throws PipeException, InterruptedException {
        String nextFromIn = this.input.next();
        if (nextFromIn == null) {
            this.next = null;
        } else {
            HashMap<String, String> row = new HashMap<String, String>();
            String[] rowValues = this.splitRow(nextFromIn);
            if (rowValues.length != this.columnNames.length) {
                throw new ValidationPipeException("Number of columns in input is " + rowValues.length + ", but expected " + this.columnNames.length);
            }
            for (int i = 0; i < this.columnNames.length; ++i) {
                row.put(this.columnNames[i], rowValues[i]);
            }
            this.next = this.rowConverter.apply(row);
        }
    }

    private String[] splitRow(String row) throws PipeException {
        try {
            String[] res = this.csvParser.parseLine(row);
            for (int i = 0; i < res.length; ++i) {
                String value = res[i];
                if (value == null) continue;
                res[i] = value.trim();
            }
            return res;
        }
        catch (IOException e) {
            throw new ValidationPipeException("Illegal CSV row - |" + row + "|", e);
        }
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    public T peek() {
        return this.next;
    }

    @Override
    public float getProgress() {
        return this.input.getProgress();
    }
}

