/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.sync.inter;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.pipecraft.pipes.exceptions.IOPipeException;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.sync.Pipe;
import org.pipecraft.pipes.utils.PipeSupplier;

public class ConcatPipe<T>
implements Pipe<T> {
    private final List<PipeSupplier<T>> inputs;
    private volatile int currPipeIndex;
    private volatile Pipe<T> currPipe;
    private T next;

    public ConcatPipe(List<PipeSupplier<T>> inputs) {
        this.inputs = inputs;
    }

    public ConcatPipe(PipeSupplier<T> ... inputs) {
        this(Arrays.asList(inputs));
    }

    @Override
    public void close() throws IOException {
        if (this.currPipe != null) {
            this.currPipe.close();
        }
    }

    @Override
    public T next() throws PipeException, InterruptedException {
        T toReturn = this.next;
        this.prepareNext();
        return toReturn;
    }

    @Override
    public T peek() {
        return this.next;
    }

    public static <T> ConcatPipe<T> fromPipes(List<Pipe<T>> inputs) {
        return new ConcatPipe<T>(inputs.stream().map(p -> () -> p).collect(Collectors.toList()));
    }

    @SafeVarargs
    public static <T> ConcatPipe<T> fromPipes(Pipe<T> ... inputs) {
        return ConcatPipe.fromPipes(Arrays.asList(inputs));
    }

    private void prepareNext() throws PipeException, InterruptedException {
        try {
            while (this.currPipeIndex < this.inputs.size()) {
                this.next = this.currPipe.next();
                if (this.next == null) {
                    this.currPipe.close();
                    if (++this.currPipeIndex >= this.inputs.size()) continue;
                    this.currPipe = this.inputs.get(this.currPipeIndex).get();
                    this.currPipe.start();
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new IOPipeException(e);
        }
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        try {
            if (this.inputs.size() > 0) {
                this.currPipe = this.inputs.get(0).get();
                this.currPipe.start();
                this.prepareNext();
            }
        }
        catch (IOException e) {
            throw new IOPipeException(e);
        }
    }

    @Override
    public float getProgress() {
        if (this.inputs.size() == 0) {
            return 1.0f;
        }
        return (float)Math.min(1.0, (double)((float)this.currPipeIndex + this.currPipe.getProgress()) / (double)this.inputs.size());
    }
}

