/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.sync.inter;

import java.io.IOException;
import org.pipecraft.pipes.exceptions.IOPipeException;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.sync.Pipe;
import org.pipecraft.pipes.sync.source.EmptyPipe;
import org.pipecraft.pipes.utils.PipeFactory;

public class FlexibleMapPipe<S, T>
implements Pipe<T> {
    private final Pipe<S> input;
    private final PipeFactory<S, ? extends T> factory;
    private Pipe<? extends T> currPipe = EmptyPipe.instance();
    private T next;

    public FlexibleMapPipe(Pipe<S> input, PipeFactory<S, ? extends T> factory) {
        this.input = input;
        this.factory = factory;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    public T next() throws PipeException, InterruptedException {
        T toReturn = this.next;
        this.prepareNext();
        return toReturn;
    }

    @Override
    public T peek() {
        return this.next;
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        this.input.start();
        this.prepareNext();
    }

    private void prepareNext() throws PipeException, InterruptedException {
        try {
            while ((this.next = this.currPipe.next()) == null) {
                this.currPipe.close();
                S nextFromInput = this.input.next();
                if (nextFromInput != null) {
                    this.currPipe = this.factory.get(nextFromInput);
                    this.currPipe.start();
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new IOPipeException(e);
        }
    }

    @Override
    public float getProgress() {
        return this.input.getProgress();
    }
}

