/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.sync.inter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.pipecraft.infra.io.FileWriteOptions;
import org.pipecraft.pipes.exceptions.IOPipeException;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.serialization.EncoderFactory;
import org.pipecraft.pipes.serialization.ItemEncoder;
import org.pipecraft.pipes.sync.Pipe;
import org.pipecraft.pipes.sync.inter.DelegatePipe;

public class IntermediateBinFileWriterPipe<T>
extends DelegatePipe<T> {
    private final FileWriteOptions writeOptions;
    private final Pipe<T> input;
    private final EncoderFactory<? super T> encoderFactory;
    private final File outputFile;
    private ItemEncoder<? super T> encoder;

    public IntermediateBinFileWriterPipe(Pipe<T> input, File outputFile, FileWriteOptions options, EncoderFactory<? super T> encoderFactory) {
        super(input);
        if (options.isTemp()) {
            outputFile.deleteOnExit();
        }
        this.outputFile = outputFile;
        this.writeOptions = options;
        this.input = input;
        this.encoderFactory = encoderFactory;
    }

    public IntermediateBinFileWriterPipe(Pipe<T> input, File outputFile, EncoderFactory<? super T> encoderFactory) {
        this(input, outputFile, new FileWriteOptions(), encoderFactory);
    }

    @Override
    public void close() throws IOException {
        this.input.close();
        if (this.encoder != null) {
            this.encoder.close();
        }
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        super.start();
        try {
            FileOutputStream os = new FileOutputStream(this.outputFile, this.writeOptions.isAppend());
            this.encoder = this.encoderFactory.newEncoder(os, this.writeOptions);
        }
        catch (IOException e) {
            throw new IOPipeException(e);
        }
    }

    @Override
    public T next() throws PipeException, InterruptedException {
        try {
            Object next = super.next();
            if (next != null) {
                this.encoder.encode(next);
            }
            return next;
        }
        catch (IOException e) {
            throw new IOPipeException(e);
        }
    }
}

