/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.sync.inter;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableInt;
import org.pipecraft.infra.concurrent.FailableFunction;
import org.pipecraft.infra.io.FileWriteOptions;
import org.pipecraft.pipes.exceptions.IOPipeException;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.serialization.EncoderFactory;
import org.pipecraft.pipes.serialization.ItemEncoder;
import org.pipecraft.pipes.sync.Pipe;

public class IntermediateSharderBySeqPipe<T>
implements Pipe<T> {
    private final Pipe<T> input;
    private final EncoderFactory<? super T> encoderFactory;
    private final FailableFunction<? super T, String, PipeException> selector;
    private final File folder;
    private final FileWriteOptions fileWriteOptions;
    private Map<String, MutableInt> counts;
    private volatile Map<String, Integer> finalCounts;
    private ItemEncoder<? super T> encoder;
    private T next;
    private String curShardId;

    public IntermediateSharderBySeqPipe(Pipe<T> input, EncoderFactory<? super T> encoderFactory, FailableFunction<? super T, String, PipeException> shardSelectorFunction, File folder, FileWriteOptions fileWriteOptions) {
        this.input = input;
        this.encoderFactory = encoderFactory;
        this.selector = shardSelectorFunction;
        this.folder = folder;
        this.fileWriteOptions = fileWriteOptions;
    }

    public IntermediateSharderBySeqPipe(Pipe<T> input, EncoderFactory<? super T> encoderFactory, FailableFunction<? super T, String, PipeException> shardSelectorFunction, File folder) {
        this(input, encoderFactory, shardSelectorFunction, folder, new FileWriteOptions());
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        this.counts = new HashMap<String, MutableInt>();
        this.input.start();
        this.next = this.input.next();
        if (this.next != null) {
            this.curShardId = this.selector.apply(this.next);
            this.encoder = this.createEncoder(this.curShardId);
        }
    }

    private void prepareNext() throws PipeException, InterruptedException {
        this.next = this.input.next();
        if (this.next == null) {
            IntermediateSharderBySeqPipe.closeNullSafe(this.encoder);
            return;
        }
        String shardId = this.selector.apply(this.next);
        if (!shardId.equals(this.curShardId)) {
            IntermediateSharderBySeqPipe.closeNullSafe(this.encoder);
            this.encoder = this.createEncoder(shardId);
            this.curShardId = shardId;
        }
    }

    @Override
    public T next() throws PipeException, InterruptedException {
        try {
            T toReturn = this.next;
            if (this.next != null) {
                this.encoder.encode(this.next);
                this.counts.computeIfAbsent(this.curShardId, id -> new MutableInt()).increment();
                this.prepareNext();
            } else {
                this.finalCounts = this.counts.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, p -> ((MutableInt)p.getValue()).intValue()));
            }
            return toReturn;
        }
        catch (IOException e) {
            throw new IOPipeException(e);
        }
    }

    @Override
    public T peek() {
        return this.next;
    }

    public Map<String, Integer> getShardSizes() {
        return this.finalCounts;
    }

    private static void closeNullSafe(Closeable closeable) throws IOPipeException {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            throw new IOPipeException(e);
        }
    }

    @Override
    public float getProgress() {
        return this.input.getProgress();
    }

    private ItemEncoder<? super T> createEncoder(String shardId) throws IOPipeException {
        try {
            File shardFile = new File(this.folder, shardId);
            FileOutputStream os = new FileOutputStream(shardFile, this.fileWriteOptions.isAppend());
            if (this.fileWriteOptions.isTemp()) {
                shardFile.deleteOnExit();
            }
            return this.encoderFactory.newEncoder(os, this.fileWriteOptions);
        }
        catch (IOException e) {
            throw new IOPipeException(e);
        }
    }
}

