/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.sync.inter;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.pipecraft.infra.concurrent.FailableFunction;
import org.pipecraft.infra.io.FileUtils;
import org.pipecraft.infra.io.FileWriteOptions;
import org.pipecraft.pipes.exceptions.IOPipeException;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.sync.Pipe;
import org.pipecraft.pipes.sync.inter.DelegatePipe;

public class IntermediateTxtFileWriterPipe<T>
extends DelegatePipe<T> {
    private final FailableFunction<T, String, PipeException> stringMapper;
    private final File output;
    private final Charset charset;
    private final FileWriteOptions writeOptions;
    private BufferedWriter bw;

    public IntermediateTxtFileWriterPipe(Pipe<T> input, File output, Charset charset, FileWriteOptions options, FailableFunction<T, String, PipeException> stringMapper) {
        super(input);
        this.output = output;
        this.charset = charset;
        this.writeOptions = options;
        this.stringMapper = stringMapper;
    }

    public IntermediateTxtFileWriterPipe(Pipe<T> input, File output, Charset charset, FileWriteOptions options) {
        this(input, output, charset, options, Object::toString);
    }

    public IntermediateTxtFileWriterPipe(Pipe<T> input, File output, Charset charset, FailableFunction<T, String, PipeException> stringMapper) {
        this(input, output, charset, new FileWriteOptions(), stringMapper);
    }

    public IntermediateTxtFileWriterPipe(Pipe<T> input, File output, FailableFunction<T, String, PipeException> stringMapper) {
        this(input, output, StandardCharsets.UTF_8, stringMapper);
    }

    public IntermediateTxtFileWriterPipe(Pipe<T> input, File output, FileWriteOptions options) {
        this(input, output, StandardCharsets.UTF_8, options);
    }

    public IntermediateTxtFileWriterPipe(Pipe<T> input, File output, FileWriteOptions options, FailableFunction<T, String, PipeException> stringMapper) {
        this(input, output, StandardCharsets.UTF_8, options, stringMapper);
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.bw != null) {
            this.bw.close();
        }
    }

    @Override
    public T next() throws PipeException, InterruptedException {
        try {
            Object next = this.getOriginPipe().next();
            if (next != null) {
                this.bw.write(this.stringMapper.apply(next));
                this.bw.newLine();
            }
            return next;
        }
        catch (IOException e) {
            throw new IOPipeException(e);
        }
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        try {
            this.bw = FileUtils.getWriter(this.output, this.charset, this.writeOptions);
            super.start();
        }
        catch (IOException e) {
            throw new IOPipeException(e);
        }
    }
}

